/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.sql;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.sql.CockroachDbSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.Db2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.H2ServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.HsqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.MsSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.MySqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.OracleServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.PostgresSqlServerTimeStatementsSource;
import net.javacrumbs.shedlock.provider.sql.PostgresSqlStatementsSource;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlStatementsSource {
    protected final SqlConfiguration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SqlStatementsSource.class);

    SqlStatementsSource(SqlConfiguration configuration) {
        this.configuration = configuration;
    }

    public static SqlStatementsSource create(SqlConfiguration configuration) {
        DatabaseProduct databaseProduct = configuration.getDatabaseProduct();
        if (configuration.getUseDbTime()) {
            if (databaseProduct == null) {
                throw new IllegalStateException("DatabaseProduct must be set when using DB time");
            }
            SqlStatementsSource statementsSource = SqlStatementsSource.createDbTimeStatementSource(databaseProduct, configuration);
            logger.debug("Using {}", (Object)statementsSource.getClass().getSimpleName());
            return statementsSource;
        }
        if (Objects.equals((Object)databaseProduct, (Object)DatabaseProduct.POSTGRES_SQL)) {
            logger.debug("Using PostgresSqlStatementsSource");
            return new PostgresSqlStatementsSource(configuration);
        }
        logger.debug("Using SqlStatementsSource");
        return new SqlStatementsSource(configuration);
    }

    private static SqlStatementsSource createDbTimeStatementSource(DatabaseProduct databaseProduct, SqlConfiguration configuration) {
        return switch (databaseProduct) {
            case DatabaseProduct.POSTGRES_SQL -> new PostgresSqlServerTimeStatementsSource(configuration);
            case DatabaseProduct.COCKROACH_DB -> new CockroachDbSqlServerTimeStatementsSource(configuration);
            case DatabaseProduct.SQL_SERVER -> new MsSqlServerTimeStatementsSource(configuration);
            case DatabaseProduct.ORACLE -> new OracleServerTimeStatementsSource(configuration);
            case DatabaseProduct.MY_SQL, DatabaseProduct.MARIA_DB -> new MySqlServerTimeStatementsSource(configuration);
            case DatabaseProduct.HQL -> new HsqlServerTimeStatementsSource(configuration);
            case DatabaseProduct.H2 -> new H2ServerTimeStatementsSource(configuration);
            case DatabaseProduct.DB2 -> new Db2ServerTimeStatementsSource(configuration);
            default -> throw new UnsupportedOperationException("DB time is not supported for database product: " + String.valueOf((Object)databaseProduct));
        };
    }

    public Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockUntil", this.timestamp(lockConfiguration.getLockAtMostUntil()), "now", this.timestamp(ClockProvider.now()), "lockedBy", this.configuration.getLockedByValue(), "unlockTime", this.timestamp(lockConfiguration.getUnlockTime()));
    }

    private Object timestamp(Instant time) {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone != null) {
            return time.atZone(timeZone.toZoneId());
        }
        return time.atZone(ZoneId.systemDefault());
    }

    public String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, :lockUntil, :now, :lockedBy)";
    }

    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil, " + this.lockedAt() + " = :now, " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= :now";
    }

    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > :now";
    }

    public String getUnlockStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :unlockTime WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    String name() {
        return this.configuration.getColumnNames().getName();
    }

    String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    String tableName() {
        return this.configuration.getTableName();
    }
}

