/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.sql;

import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.support.Utils;
import org.jspecify.annotations.Nullable;

public abstract class SqlConfiguration {
    public static final String DEFAULT_TABLE_NAME = "shedlock";
    private final @Nullable DatabaseProduct databaseProduct;
    private final String tableName;
    private final @Nullable TimeZone timeZone;
    private final ColumnNames columnNames;
    private final String lockedByValue;
    private final boolean useDbTime;

    protected SqlConfiguration(@Nullable DatabaseProduct databaseProduct, boolean dbUpperCase, String tableName, @Nullable TimeZone timeZone, ColumnNames columnNames, String lockedByValue, boolean useDbTime) {
        this.databaseProduct = databaseProduct;
        Objects.requireNonNull(tableName, "tableName can not be null");
        this.tableName = dbUpperCase ? tableName.toUpperCase() : tableName;
        this.timeZone = timeZone;
        Objects.requireNonNull(columnNames, "columnNames can not be null");
        this.columnNames = dbUpperCase ? columnNames.toUpperCase() : columnNames;
        this.lockedByValue = Objects.requireNonNull(lockedByValue, "lockedByValue can not be null");
        if (useDbTime && timeZone != null) {
            throw new IllegalArgumentException("Can not set both useDbTime and timeZone");
        }
        this.useDbTime = useDbTime;
    }

    public @Nullable DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public String getTableName() {
        return this.tableName;
    }

    public @Nullable TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ColumnNames getColumnNames() {
        return this.columnNames;
    }

    public String getLockedByValue() {
        return this.lockedByValue;
    }

    public boolean getUseDbTime() {
        return this.useDbTime;
    }

    public static class ColumnNames {
        private final String name;
        private final String lockUntil;
        private final String lockedAt;
        private final String lockedBy;

        public ColumnNames(String name, String lockUntil, String lockedAt, String lockedBy) {
            this.name = Objects.requireNonNull(name, "'name' column name can not be null");
            this.lockUntil = Objects.requireNonNull(lockUntil, "'lockUntil' column name can not be null");
            this.lockedAt = Objects.requireNonNull(lockedAt, "'lockedAt' column name can not be null");
            this.lockedBy = Objects.requireNonNull(lockedBy, "'lockedBy' column name can not be null");
        }

        public String getName() {
            return this.name;
        }

        public String getLockUntil() {
            return this.lockUntil;
        }

        public String getLockedAt() {
            return this.lockedAt;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        ColumnNames toUpperCase() {
            return new ColumnNames(this.name.toUpperCase(), this.lockUntil.toUpperCase(), this.lockedAt.toUpperCase(), this.lockedBy.toUpperCase());
        }
    }

    public static abstract class SqlConfigurationBuilder<T extends SqlConfigurationBuilder<T>> {
        protected @Nullable DatabaseProduct databaseProduct;
        protected String tableName = "shedlock";
        protected String lockedByValue = Utils.getHostname();
        protected ColumnNames columnNames = new ColumnNames("name", "lock_until", "locked_at", "locked_by");
        protected boolean dbUpperCase = false;
        protected boolean useDbTime = false;

        public T withTableName(String tableName) {
            this.tableName = tableName;
            return this.getThis();
        }

        public T withColumnNames(ColumnNames columnNames) {
            this.columnNames = columnNames;
            return this.getThis();
        }

        public T withDbUpperCase(boolean dbUpperCase) {
            this.dbUpperCase = dbUpperCase;
            return this.getThis();
        }

        public T withDatabaseProduct(DatabaseProduct databaseProduct) {
            this.databaseProduct = databaseProduct;
            return this.getThis();
        }

        public T withLockedByValue(String lockedBy) {
            this.lockedByValue = lockedBy;
            return this.getThis();
        }

        public T usingDbTime() {
            this.useDbTime = true;
            return this.getThis();
        }

        protected T getThis() {
            return (T)this;
        }
    }
}

