/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.test.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonParser;
import com.squareup.moshi.Moshi;
import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.json.JSONTokener;

public class JsonTestUtils {
    public static Object readByJackson2(String value) {
        try {
            return new ObjectMapper().readTree(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object readByJohnzon(String value) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(value));){
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }

    public static Object readByGson(String value) {
        return JsonParser.parseString((String)value);
    }

    public static Object readByJsonOrg(String value) {
        return new JSONTokener(value).nextValue();
    }

    public static Object readByMoshi(String value) {
        Moshi moshi = new Moshi.Builder().build();
        try {
            return moshi.adapter(Map.class).fromJson(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

