/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.test.base;

import java.math.BigDecimal;
import java.util.Collections;
import net.javacrumbs.jsonunit.ConfigurableJsonMatcher;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.JsonMatchers;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.core.util.ResourceUtils;
import net.javacrumbs.jsonunit.test.base.RecordingDifferenceListener;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractJsonMatchersTest {
    @AfterEach
    void reset() {
        JsonAssert.setTolerance(null);
        JsonAssert.resetOptions();
    }

    @Test
    void testEquals() {
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonEquals((Object)"{\n\"test\": 1\n}"));
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)CoreMatchers.not((Matcher)JsonMatchers.jsonEquals((Object)"{\n\"test\": 2\n}")));
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartEquals((String)"test", (Object)"1"));
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartEquals((String)"test", (Object)1));
        MatcherAssert.assertThat((Object)"{\"test\":[1, 2, 3]}", (Matcher)JsonMatchers.jsonPartEquals((String)"test[0]", (Object)"1"));
        MatcherAssert.assertThat((Object)"{\"foo\":\"bar\",\"test\": 2}", (Matcher)JsonMatchers.jsonEquals((Object)"{\n\"test\": 2,\n\"foo\":\"bar\"}"));
        MatcherAssert.assertThat((Object)"{}", (Matcher)JsonMatchers.jsonEquals((Object)"{}"));
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonEquals((Object)ResourceUtils.resource((String)"test.json")));
        MatcherAssert.assertThat((Object)"{\"test\":2}", (Matcher)CoreMatchers.not((Matcher)JsonMatchers.jsonEquals((Object)ResourceUtils.resource((String)"test.json"))));
    }

    @Test
    void testJsonPartMatches() {
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartMatches((String)"test", (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L))));
    }

    @Test
    void jsonPartMatchesShouldReturnNiceException() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartMatches((String)"test", (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))))).hasMessage("\nExpected: node \"test\" is <2>\n     but: was <1>");
    }

    @Test
    void jsonPartMatchesShouldFailOnMissing() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartMatches((String)"test2", (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))))).hasMessage("\nExpected: node \"test2\" is <2>\n     but: Node \"test2\" is missing.");
    }

    @Test
    void shouldAddPathPrefixToPath() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$"), (Matcher)JsonMatchers.jsonPartMatches((String)"test", (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))))).hasMessage("\nExpected: node \"$.test\" is <2>\n     but: was <1>");
    }

    @Test
    void testJsonPartMatchesArray() {
        MatcherAssert.assertThat((Object)"{\"test\":[1, 2, 3]}", (Matcher)JsonMatchers.jsonPartMatches((String)"test", (Matcher)CoreMatchers.hasItems((Object[])new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)})));
    }

    @Test
    void jsonPartMatchesShouldReturnNiceExceptionForArray() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":[1, 2, 3]}", (Matcher)JsonMatchers.jsonPartMatches((String)"test", (Matcher)CoreMatchers.hasItems((Object[])new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(4L)})))).hasMessage("\nExpected: node \"test\" (a collection containing <1> and a collection containing <2> and a collection containing <4>)\n     but: was <[1, 2, 3]>");
    }

    @Test
    void ifMatcherDoesNotMatchReportDifference() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":-1}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\": \"${json-unit.matches:positive}\"}").withMatcher("positive", Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))))).hasMessage("\nExpected: {\"test\": \"${json-unit.matches:positive}\"}\n     but: JSON documents are different:\nMatcher \"positive\" does not match value -1 in node \"test\". Expected a value greater than <0> but <-1> was less than <0>\n");
    }

    @Test
    void pathShouldBeIgnoredForDifferentValue() {
        MatcherAssert.assertThat((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").whenIgnoringPaths(new String[]{"root.ignored"}));
    }

    @Test
    void shouldNotFailOnEmptyInput() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":1}"))).hasMessage("\nExpected: {\"test\":1}\n     but: JSON documents are different:\nDifferent value found in node \"\", expected <{\"test\":1}> but was <\"\">.\n");
    }

    @Test
    void testGenericsStringInference() {
        this.doAssertThat("{\"test\":1}", (Matcher<String>)JsonMatchers.jsonStringPartEquals((String)"test", (Object)"1"));
        this.doAssertThat("{\"test\":1}", (Matcher<String>)JsonMatchers.jsonStringEquals((Object)"{\"test\" : 1}"));
        this.doAssertThat("{\"test\":1}", (Matcher<String>)JsonMatchers.jsonPartEquals((String)"test", (Object)"1"));
        this.doAssertThat("{\"test\":1}", (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"test\" : 1}"));
    }

    private void doAssertThat(String text, Matcher<String> matcher) {
        MatcherAssert.assertThat((Object)text, matcher);
    }

    @Test
    void testToleranceStatic() {
        JsonAssert.setTolerance((double)0.001);
        MatcherAssert.assertThat((Object)"{\"test\":1.00001}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":1}"));
    }

    @Test
    void testTolerance() {
        MatcherAssert.assertThat((Object)"{\"test\":1.00001}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":1}").withTolerance(0.001).when(Option.IGNORING_EXTRA_FIELDS, new Option[0]));
    }

    @Test
    void shouldIgnoreExtraFields() {
        MatcherAssert.assertThat((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"b\":2}}").when(Option.IGNORING_EXTRA_FIELDS, new Option[0]));
    }

    @Test
    void hasItemShouldWork() {
        MatcherAssert.assertThat(Collections.singletonList("{\"test\":1}"), (Matcher)Matchers.contains((Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":1}")));
    }

    @Test
    void testAssertDifferentTypeInt() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":\"1\"}", (Matcher)JsonMatchers.jsonPartEquals((String)"test", (Object)1))).hasMessage("\nExpected: 1 in \"test\"\n     but: JSON documents are different:\nDifferent value found in node \"test\", expected <1> but was <\"1\">.\n");
    }

    @Test
    void testGenericsInt() {
        ConfigurableJsonMatcher intMatcher = JsonMatchers.jsonEquals((Object)1);
        MatcherAssert.assertThat((Object)1, (Matcher)intMatcher);
    }

    @Test
    void testGenericsIntAndString() {
        ConfigurableJsonMatcher stringMatcher = JsonMatchers.jsonPartEquals((String)"test", (Object)1);
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)stringMatcher);
    }

    @Test
    void testDifferentValue() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonEquals((Object)"{\n\"test\": 2\n}"))).hasMessage("\nExpected: {\n\"test\": 2\n}\n     but: JSON documents are different:\nDifferent value found in node \"test\", expected <2> but was <1>.\n");
    }

    @Test
    void testDifferentStructure() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonEquals((Object)"{\n\"test2\": 2\n}"))).hasMessage("\nExpected: {\n\"test2\": 2\n}\n     but: JSON documents are different:\nDifferent keys found in node \"\", missing: \"test2\", extra: \"test\", expected <{\"test2\":2}> but was <{\"test\":1}>\n");
    }

    @Test
    void testDifferentPartValue() {
        RecordingDifferenceListener listener = new RecordingDifferenceListener();
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonPartEquals((String)"test", (Object)"2").withDifferenceListener((DifferenceListener)listener))).hasMessage("\nExpected: 2 in \"test\"\n     but: JSON documents are different:\nDifferent value found in node \"test\", expected <2> but was <1>.\n");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listener.getDifferenceList().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DIFFERENT Expected 2 in test got 1 in test", (Object)listener.getDifferenceList().get(0).toString());
    }

    @Test
    void testAbsent() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonNodeAbsent((String)"test"))).hasMessage("\nExpected: Node \"test\" is absent.\n     but: Node \"test\" is \"1\".");
    }

    @Test
    void testAbsentShouldAddPathToThePrefix() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$"), (Matcher)JsonMatchers.jsonNodeAbsent((String)"test"))).hasMessage("\nExpected: Node \"$.test\" is absent.\n     but: Node \"$.test\" is \"1\".");
    }

    @Test
    void testAbsentOk() {
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonNodeAbsent((String)"different"));
    }

    @Test
    void testPresent() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonNodePresent((String)"test.a"))).hasMessage("\nExpected: Node \"test.a\" is present.\n     but: Node \"test.a\" is missing.");
    }

    @Test
    void testPresentShouldAddPathToThePrefix() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$"), (Matcher)JsonMatchers.jsonNodePresent((String)"test.a"))).hasMessage("\nExpected: Node \"$.test.a\" is present.\n     but: Node \"$.test.a\" is missing.");
    }

    @Test
    void testPresentIfNullAndTreatingNullAsAbsent() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":null}", (Matcher)JsonMatchers.jsonNodePresent((String)"test").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]))).hasMessage("\nExpected: Node \"test\" is present.\n     but: Node \"test\" is missing.");
    }

    @Test
    void testPresentOk() {
        MatcherAssert.assertThat((Object)"{\"test\":1}", (Matcher)JsonMatchers.jsonNodePresent((String)"test"));
    }

    @Test
    void testNullAndAbsent() {
        Assertions.assertThatThrownBy(() -> MatcherAssert.assertThat((Object)"{\"test\":{\"a\":1, \"b\": null}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"a\":1}}"))).hasMessage("\nExpected: {\"test\":{\"a\":1}}\n     but: JSON documents are different:\nDifferent keys found in node \"test\", extra: \"test.b\", expected <{\"a\":1}> but was <{\"a\":1,\"b\":null}>\n");
    }

    @Test
    void shouldIgnoreValues() {
        MatcherAssert.assertThat((Object)"{\"test\":{\"a\":3,\"b\":2,\"c\":1}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":3}}").when(Option.IGNORING_VALUES, new Option[0]));
    }

    @Test
    void testTreatNullAsAbsent() {
        JsonAssert.setOptions((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]);
        MatcherAssert.assertThat((Object)"{\"test\":{\"a\":1, \"b\": null}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"a\":1}}"));
    }

    @Test
    void testJsonNode() {
        MatcherAssert.assertThat((Object)this.readValue("{\"test\":1}"), (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":1}"));
    }

    @Test
    void jsonEqualsResourceShouldReturnReasonWhenDiffers() {
        try {
            MatcherAssert.assertThat((Object)"{\"test\":2}", (Matcher)JsonMatchers.jsonEquals((Object)ResourceUtils.resource((String)"test.json")));
            this.expectException();
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)CoreMatchers.containsString((String)"\n     but: JSON documents are different:\nDifferent value found in node \"test\", expected <1> but was <2>.\n"));
        }
    }

    @Test
    void jsonEqualsResourceShouldReturnReasonWhenResourceIsMissing() {
        try {
            MatcherAssert.assertThat((Object)"{\"test\":2}", (Matcher)JsonMatchers.jsonEquals((Object)ResourceUtils.resource((String)"nonsense")));
            this.expectException();
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"resource 'nonsense' not found", (Object)e.getMessage());
        }
    }

    @Test
    void jsonEqualsResourceShouldReturnReasonWhenNullPassedAsParameter() {
        try {
            MatcherAssert.assertThat((Object)"{\"test\":2}", (Matcher)JsonMatchers.jsonEquals((Object)ResourceUtils.resource(null)));
            this.expectException();
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"'null' passed instead of resource name", (Object)e.getMessage());
        }
    }

    @Test
    void nullPointerExceptionTest() {
        String message = "{     \"properties\":{         \"attr\":\"123\"     }}";
        String path = "properties.another[0]";
        String expected = "VALUE";
        JsonMatchers.jsonPartEquals((String)path, (Object)expected).matches((Object)message);
    }

    @Test
    void testSpecificPath() {
        MatcherAssert.assertThat((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":3}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":4}}").when(ConfigurationWhen.path((String)"test.c"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}));
    }

    @Test
    void testSpecificPathNot() {
        MatcherAssert.assertThat((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":3}}", (Matcher)JsonMatchers.jsonEquals((Object)"{\"test\":{\"a\":5,\"b\":6,\"c\":3}}").when(Option.IGNORING_VALUES, new Option[0]).when(ConfigurationWhen.path((String)"test.c"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}));
    }

    @Test
    void matcherShouldDescribeTheOnlyMatch() {
        ConfigurableJsonMatcher matcher = JsonMatchers.jsonEquals((Object)"{\"test\": 1}");
        String actual = "{\"test\": 2}";
        org.junit.jupiter.api.Assertions.assertFalse((boolean)matcher.matches((Object)actual));
        StringDescription description = new StringDescription();
        matcher.describeMismatch((Object)actual, (Description)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nDifferent value found in node \"test\", expected <1> but was <2>.\n", (Object)description.toString());
    }

    private void expectException() {
        org.junit.jupiter.api.Assertions.fail((String)"Exception expected");
    }

    protected abstract Object readValue(String var1);
}

