/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.jspecify.annotations.NonNull;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class JsonUnitResultMatchers
extends AbstractSpringMatchers<JsonUnitResultMatchers, ResultMatcher> {
    private JsonUnitResultMatchers(Configuration configuration, Function<Object, Object> jsonTransformer) {
        super(configuration, jsonTransformer);
    }

    public static JsonUnitResultMatchers json() {
        return new JsonUnitResultMatchers(Configuration.empty(), Function.identity());
    }

    @Override
    @NonNull ResultMatcher matcher(@NonNull Consumer<InternalMatcher> matcher) {
        return new JsonResultMatcher(this.configuration, matcher, this.jsonTransformer);
    }

    @Override
    @NonNull JsonUnitResultMatchers matchers(@NonNull Configuration configuration, @NonNull Function<Object, Object> jsonTransformer) {
        return new JsonUnitResultMatchers(configuration, jsonTransformer);
    }

    private static class JsonResultMatcher
    extends AbstractSpringMatcher
    implements ResultMatcher {
        private JsonResultMatcher(@NonNull Configuration configuration, @NonNull Consumer<InternalMatcher> matcher, @NonNull Function<Object, Object> jsonTransformer) {
            super(configuration, matcher, jsonTransformer);
        }

        public void match(@NonNull MvcResult result) throws Exception {
            String actual = this.getContentAsString(result.getResponse());
            this.doMatch(actual);
        }

        private @NonNull String getContentAsString(@NonNull MockHttpServletResponse response) throws UnsupportedEncodingException {
            return response.getContentAsString(StandardCharsets.UTF_8);
        }
    }
}

