/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatcher;
import net.javacrumbs.jsonunit.spring.AbstractSpringMatchers;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class JsonUnitResultMatchers
extends AbstractSpringMatchers<JsonUnitResultMatchers, ResultMatcher> {
    private JsonUnitResultMatchers(Path path, Configuration configuration) {
        super(path, configuration);
    }

    public static JsonUnitResultMatchers json() {
        return new JsonUnitResultMatchers(Path.root(), Configuration.empty());
    }

    @Override
    ResultMatcher matcher(BiConsumer<Object, InternalMatcher> matcher) {
        return new JsonResultMatcher(this.path, this.configuration, matcher);
    }

    @Override
    JsonUnitResultMatchers matchers(Path path, Configuration configuration) {
        return new JsonUnitResultMatchers(path, configuration);
    }

    private static class JsonResultMatcher
    extends AbstractSpringMatcher
    implements ResultMatcher {
        private JsonResultMatcher(Path path, Configuration configuration, BiConsumer<Object, InternalMatcher> matcher) {
            super(path, configuration, matcher);
        }

        public void match(MvcResult result) throws Exception {
            String actual = result.getResponse().getContentAsString();
            this.doMatch(actual);
        }
    }
}

