/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.javacrumbs.jsonunit.assertj.JsonAssertion;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.assertj.JsonListAssert;
import net.javacrumbs.jsonunit.assertj.JsonMapAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.InternalJsonPathUtils;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigIntegerAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.UriAssert;
import org.assertj.core.description.Description;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.util.Strings;
import org.hamcrest.Matcher;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class JsonAssert
extends AbstractAssert<JsonAssert, Object> {
    final Path path;
    final Configuration configuration;
    private final @Nullable Object actualForMatcher;

    JsonAssert(Path path, Configuration configuration, @Nullable Object actual, boolean alreadyParsed) {
        super((Object)(alreadyParsed ? JsonUtils.wrapDeserializedObject((Object)actual) : JsonUtils.convertToJson((Object)actual, (String)"actual")), JsonAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.actualForMatcher = alreadyParsed ? JsonUtils.wrapDeserializedObject((Object)actual) : actual;
        this.usingComparator(new JsonComparator(configuration, path, false));
    }

    JsonAssert(Path path, Configuration configuration, @Nullable Object actual) {
        this(path, configuration, actual, false);
    }

    JsonAssert(Object actual, Configuration configuration) {
        this(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
    }

    public JsonAssert node(String node) {
        return new JsonAssert(this.path.to(node), this.configuration, JsonUtils.getNode((Object)this.actual, (String)node));
    }

    public JsonAssert and(JsonAssertion ... assertions) {
        Arrays.stream(assertions).forEach(a -> a.doAssert(this));
        return this;
    }

    public JsonAssert isEqualTo(@Nullable Object expected) {
        Diff diff = Diff.create((Object)expected, (Object)this.actual, (String)"fullJson", (Path)this.path.asPrefix(), (Configuration)this.configuration);
        String overridingErrorMessage = this.info.overridingErrorMessage();
        if (!Strings.isNullOrEmpty((String)overridingErrorMessage) && !diff.similar()) {
            this.failWithMessage(overridingErrorMessage, new Object[0]);
        } else {
            diff.failIfDifferent(MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]));
        }
        return this;
    }

    public StringAssert isStringEqualTo(String expected) {
        return (StringAssert)this.isString().isEqualTo(expected);
    }

    public JsonMapAssert isObject() {
        Node node = this.assertType(Node.NodeType.OBJECT);
        return this.describe(new JsonMapAssert((Map)node.getValue(), this.path.asPrefix(), this.configuration));
    }

    public BigDecimalAssert isNumber() {
        Node node = this.assertType(Node.NodeType.NUMBER);
        return this.createBigDecimalAssert(node.decimalValue());
    }

    public BigIntegerAssert isIntegralNumber() {
        Node node = this.internalMatcher().assertIntegralNumber();
        return this.describe(new BigIntegerAssert(node.decimalValue().toBigIntegerExact()));
    }

    public BigDecimalAssert asNumber() {
        this.internalMatcher().isPresent(Node.NodeType.NUMBER.getDescription());
        Node node = JsonUtils.getNode((Object)this.actual, (String)"");
        if (node.getNodeType() == Node.NodeType.NUMBER) {
            return this.createBigDecimalAssert(node.decimalValue());
        }
        if (node.getNodeType() == Node.NodeType.STRING) {
            try {
                return this.createBigDecimalAssert(new BigDecimal(node.asText()));
            }
            catch (NumberFormatException e) {
                this.failWithMessage("Node \"" + String.valueOf(this.path) + "\" can not be converted to number expected: <a number> but was: <" + String.valueOf(Diff.quoteTextValue((Object)node.getValue())) + ">.", new Object[0]);
            }
        } else {
            this.internalMatcher().failOnType(node, "number or string");
        }
        return null;
    }

    private BigDecimalAssert createBigDecimalAssert(BigDecimal value) {
        return this.describe(new BigDecimalAssert(value));
    }

    private InternalMatcher internalMatcher() {
        String description = Description.mostRelevantDescription((Description)this.info.description(), (String)("Node \"" + String.valueOf(this.path) + "\""));
        return new InternalMatcher(this.actualForMatcher, this.path.asPrefix(), "", this.configuration, description);
    }

    public JsonListAssert isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return (JsonListAssert)this.createListAssert(node).as("Node \"%s\"", new Object[]{this.path});
    }

    private JsonListAssert createListAssert(Node node) {
        return new JsonListAssert((List)node.getValue(), this.path.asPrefix(), this.configuration);
    }

    public BooleanAssert isBoolean() {
        Node node = this.assertType(Node.NodeType.BOOLEAN);
        return this.createBooleanAssert(node);
    }

    private BooleanAssert createBooleanAssert(Node node) {
        return this.describe(new BooleanAssert((Boolean)node.getValue()));
    }

    public StringAssert isString() {
        Node node = this.assertType(Node.NodeType.STRING);
        return this.createStringAssert(node);
    }

    private StringAssert createStringAssert(Node node) {
        return this.describe(new StringAssert((String)node.getValue()));
    }

    private <T extends AbstractAssert<T, ?>> T describe(T ass) {
        return (T)((AbstractAssert)ass.as("Different value found in node \"%s\"", new Object[]{this.path}));
    }

    public AbstractStringAssert<?> asString() {
        return this.isString();
    }

    public void isNull() {
        this.assertType(Node.NodeType.NULL);
    }

    public UriAssert isUri() {
        Node node = this.assertType(Node.NodeType.STRING);
        return this.describe(new UriAssert(URI.create((String)node.getValue())));
    }

    public JsonAssert isPresent() {
        this.internalMatcher().isPresent();
        return this;
    }

    public void isAbsent() {
        this.internalMatcher().isAbsent();
    }

    public JsonAssert isNotNull() {
        this.internalMatcher().isNotNull();
        return this;
    }

    private Node assertType(Node.NodeType type) {
        return this.internalMatcher().assertType(type);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT asInstanceOf(InstanceOfAssertFactory<?, ASSERT> instanceOfAssertFactory) {
        Node node = this.internalMatcher().getActualNode();
        Object ass = switch (node.getNodeType()) {
            default -> throw new IncompatibleClassChangeError();
            case Node.NodeType.OBJECT -> throw new UnsupportedOperationException("asInstanceOf is not supported for Object type");
            case Node.NodeType.ARRAY -> this.createListAssert(node);
            case Node.NodeType.STRING -> this.createStringAssert(node);
            case Node.NodeType.NUMBER -> this.createBigDecimalAssert(node.decimalValue());
            case Node.NodeType.BOOLEAN -> this.createBooleanAssert(node);
            case Node.NodeType.NULL -> new StringAssert(null);
        };
        return (ASSERT)ass.asInstanceOf(instanceOfAssertFactory);
    }

    @NullMarked
    public static class ConfigurableJsonAssert
    extends JsonAssert {
        private final @Nullable Object originalActual;

        ConfigurableJsonAssert(Path path, Configuration configuration, @Nullable Object actual) {
            super(path, configuration, actual);
            this.originalActual = actual;
        }

        ConfigurableJsonAssert(@Nullable Object actual, Configuration configuration) {
            this(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
        }

        public ConfigurableJsonAssert when(Option first, Option ... other) {
            return this.withConfiguration(c -> c.when(first, other));
        }

        public final ConfigurableJsonAssert when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
            return this.withConfiguration(c -> c.when(object, actions));
        }

        public ConfigurableJsonAssert withOptions(Option first, Option ... next) {
            return this.withConfiguration(c -> c.withOptions(first, next));
        }

        public ConfigurableJsonAssert withOptions(Collection<Option> optionsToAdd) {
            return this.withConfiguration(c -> c.withOptions(optionsToAdd));
        }

        public ConfigurableJsonAssert withConfiguration(Function<Configuration, Configuration> configurationFunction) {
            Configuration newConfiguration = configurationFunction.apply(this.configuration);
            newConfiguration = InternalJsonPathUtils.resolveJsonPaths((Object)this.originalActual, (Configuration)newConfiguration);
            return new ConfigurableJsonAssert(this.path, newConfiguration, this.actual);
        }

        public ConfigurableJsonAssert withTolerance(@Nullable BigDecimal tolerance) {
            return this.withConfiguration(c -> c.withTolerance(tolerance));
        }

        public ConfigurableJsonAssert withTolerance(double tolerance) {
            return this.withTolerance(BigDecimal.valueOf(tolerance));
        }

        public ConfigurableJsonAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
            return this.withConfiguration(c -> c.whenIgnoringPaths(pathsToBeIgnored));
        }

        public ConfigurableJsonAssert withIgnorePlaceholder(String ignorePlaceholder) {
            return this.withConfiguration(c -> c.withIgnorePlaceholder(ignorePlaceholder));
        }

        public ConfigurableJsonAssert withMatcher(String matcherName, Matcher<?> matcher) {
            return this.withConfiguration(c -> c.withMatcher(matcherName, matcher));
        }

        public ConfigurableJsonAssert withDifferenceListener(DifferenceListener differenceListener) {
            return this.withConfiguration(c -> c.withDifferenceListener(differenceListener));
        }

        public JsonAssert inPath(String jsonPath) {
            return new JsonAssert(JsonPathAdapter.inPath((Object)this.originalActual, (String)jsonPath), this.configuration);
        }

        public ConfigurableJsonAssert describedAs(Description description) {
            return (ConfigurableJsonAssert)super.describedAs(description);
        }

        public ConfigurableJsonAssert describedAs(String description, Object ... args) {
            return (ConfigurableJsonAssert)((Object)super.describedAs(description, args));
        }

        public ConfigurableJsonAssert as(Description description) {
            return (ConfigurableJsonAssert)((Object)super.as(description));
        }

        public ConfigurableJsonAssert as(String description, Object ... args) {
            return (ConfigurableJsonAssert)((Object)super.as(description, args));
        }
    }
}

