/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonMapAssert
extends AbstractMapAssert<JsonMapAssert, Map<String, Object>, String, Object> {
    private final Configuration configuration;
    private final Path path;

    JsonMapAssert(Map<String, Object> actual, Path path, Configuration configuration) {
        super(actual, JsonMapAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    @NotNull
    public JsonMapAssert isEqualTo(@Nullable Object expected) {
        return this.compare(expected, this.configuration);
    }

    @NotNull
    public JsonAssert node(@NotNull String node) {
        return new JsonAssert(this.path.to(node), this.configuration, JsonUtils.getNode((Object)this.actual, (String)node));
    }

    @NotNull
    public JsonMapAssert containsValue(@Nullable Object expected) {
        if (expected instanceof Node) {
            if (!this.contains(expected)) {
                this.throwAssertionError(ShouldContainValue.shouldContainValue((Object)this.actual, (Object)expected));
            }
            return this;
        }
        return (JsonMapAssert)super.containsValue(expected);
    }

    @NotNull
    public JsonMapAssert doesNotContainValue(@Nullable Object expected) {
        if (expected instanceof Node) {
            if (this.contains(expected)) {
                this.throwAssertionError(ShouldNotContainValue.shouldNotContainValue((Object)this.actual, (Object)expected));
            }
            return this;
        }
        return (JsonMapAssert)super.doesNotContainValue(expected);
    }

    @Deprecated
    @NotNull
    public JsonMapAssert isEqualToIgnoringGivenFields(@Nullable Object other, String ... propertiesOrFieldsToIgnore) {
        return this.compare(other, this.configuration.whenIgnoringPaths(propertiesOrFieldsToIgnore));
    }

    @Deprecated
    @NotNull
    public JsonMapAssert isEqualToComparingOnlyGivenFields(@Nullable Object other, String ... propertiesOrFieldsUsedInComparison) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonMapAssert isEqualToIgnoringNullFields(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonMapAssert isEqualToComparingFieldByField(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    @Deprecated
    @NotNull
    public JsonMapAssert isEqualToComparingFieldByFieldRecursively(@Nullable Object other) {
        throw this.unsupportedOperation();
    }

    public JsonMapAssert containsEntry(String key, Object value) {
        return (JsonMapAssert)this.contains((Map.Entry[])Arrays.array((Object[])new MapEntry[]{Assertions.entry((Object)key, (Object)value)}));
    }

    @SafeVarargs
    protected final JsonMapAssert containsAnyOfForProxy(Map.Entry<? extends String, ?> ... entries) {
        boolean anyMatch = java.util.Arrays.stream(entries).anyMatch(this::doesContainEntry);
        if (!anyMatch) {
            this.throwAssertionError(ShouldContainAnyOf.shouldContainAnyOf((Object)this.actual, entries));
        }
        return this;
    }

    public JsonMapAssert containsAllEntriesOf(Map<? extends String, ?> other) {
        return (JsonMapAssert)this.contains(this.toEntries(other));
    }

    @SafeVarargs
    @Deprecated
    public final JsonMapAssert containsExactlyForProxy(Map.Entry<? extends String, ?> ... entries) {
        return (JsonMapAssert)super.containsExactlyForProxy((Map.Entry[])entries);
    }

    @Deprecated
    public JsonMapAssert containsExactlyEntriesOf(Map<? extends String, ?> map) {
        return (JsonMapAssert)super.containsExactlyEntriesOf(map);
    }

    @SafeVarargs
    protected final JsonMapAssert containsOnlyForProxy(Map.Entry<? extends String, ?> ... expected) {
        Map<String, Object> expectedAsMap = java.util.Arrays.stream(expected).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.isEqualTo(JsonUtils.wrapDeserializedObject(expectedAsMap));
    }

    @NotNull
    private List<Map.Entry<? extends String, ?>> entriesNotFoundInMap(Map.Entry<? extends String, ?>[] expected) {
        return java.util.Arrays.stream(expected).filter(entry -> !this.doesContainEntry((Map.Entry<? extends String, ?>)entry)).collect(Collectors.toList());
    }

    @SafeVarargs
    protected final JsonMapAssert containsForProxy(Map.Entry<? extends String, ?> ... expected) {
        List<Map.Entry<String, ?>> notFound = this.entriesNotFoundInMap(expected);
        if (!notFound.isEmpty()) {
            this.throwAssertionError(ShouldContain.shouldContain((Object)this.actual, expected, notFound));
        }
        return this;
    }

    private boolean doesContainEntry(Map.Entry<? extends String, ?> entry) {
        String key = entry.getKey();
        if (!((Map)this.actual).containsKey(key)) {
            return false;
        }
        Object actualValue = ((Map)this.actual).get(key);
        Object expectedValue = entry.getValue();
        if (expectedValue instanceof Number) {
            expectedValue = JsonAssertions.json(expectedValue);
        }
        if (expectedValue instanceof Node) {
            Node value = (Node)expectedValue;
            return this.isSimilar(actualValue, value);
        }
        return Objects.deepEquals(actualValue, expectedValue);
    }

    protected JsonMapAssert containsValuesForProxy(Object ... values) {
        java.util.Arrays.stream(values).forEach(this::containsValue);
        return this;
    }

    private Map.Entry<? extends String, ?>[] toEntries(Map<? extends String, ?> map) {
        return map.entrySet().toArray(new Map.Entry[0]);
    }

    @Deprecated
    public JsonMapAssert hasFieldOrProperty(String name) {
        return (JsonMapAssert)super.hasFieldOrProperty(name);
    }

    @Deprecated
    public JsonMapAssert hasFieldOrPropertyWithValue(String name, Object value) {
        return (JsonMapAssert)super.hasFieldOrPropertyWithValue(name, value);
    }

    @Deprecated
    public JsonMapAssert hasAllNullFieldsOrProperties() {
        return (JsonMapAssert)super.hasAllNullFieldsOrProperties();
    }

    @Deprecated
    public JsonMapAssert hasAllNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        return (JsonMapAssert)super.hasAllNullFieldsOrPropertiesExcept(propertiesOrFieldsToIgnore);
    }

    @Deprecated
    public JsonMapAssert hasNoNullFieldsOrProperties() {
        return (JsonMapAssert)super.hasNoNullFieldsOrProperties();
    }

    @Deprecated
    public JsonMapAssert hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        return (JsonMapAssert)super.hasNoNullFieldsOrPropertiesExcept(propertiesOrFieldsToIgnore);
    }

    @NotNull
    private UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("Operation not supported for JSON documents");
    }

    @NotNull
    private JsonMapAssert compare(@Nullable Object other, @NotNull Configuration configuration) {
        this.describedAs(null);
        Diff diff = Diff.create((Object)other, (Object)this.actual, (String)"fullJson", (Path)this.path, (Configuration)configuration);
        diff.failIfDifferent();
        return this;
    }

    private boolean contains(Object expected) {
        return ((Map)this.actual).entrySet().stream().anyMatch(entry -> this.isSimilar(entry.getValue(), expected));
    }

    private boolean isSimilar(Object actual, Object expected) {
        return Diff.create((Object)expected, (Object)actual, (String)"fullJson", (Path)this.path.asPrefix(), (Configuration)this.configuration).similar();
    }
}

