/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.javacrumbs.jsonunit.assertj.JsonAssertion;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.assertj.JsonListAssert;
import net.javacrumbs.jsonunit.assertj.JsonMapAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.InternalJsonPathUtils;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigIntegerAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.description.Description;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Strings;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonAssert
extends AbstractAssert<JsonAssert, Object> {
    final Path path;
    final Configuration configuration;
    private final InternalMatcher internalMatcher;

    JsonAssert(Path path, Configuration configuration, Object actual) {
        super((Object)JsonUtils.convertToJson((Object)actual, (String)"actual"), JsonAssert.class);
        this.path = path;
        this.configuration = configuration;
        this.internalMatcher = new InternalMatcher(actual, path.asPrefix(), "", configuration);
        this.usingComparator(new JsonComparator(configuration, path, false));
    }

    JsonAssert(Object actual, Configuration configuration) {
        this(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
    }

    @NotNull
    public JsonAssert node(@NotNull String node) {
        return new JsonAssert(this.path.to(node), this.configuration, JsonUtils.getNode((Object)this.actual, (String)node));
    }

    @NotNull
    public JsonAssert and(JsonAssertion ... assertions) {
        Arrays.stream(assertions).forEach(a -> a.doAssert(this));
        return this;
    }

    @NotNull
    public JsonAssert isEqualTo(@Nullable Object expected) {
        Diff diff = Diff.create((Object)expected, (Object)this.actual, (String)"fullJson", (Path)this.path.asPrefix(), (Configuration)this.configuration);
        String overridingErrorMessage = this.info.overridingErrorMessage();
        if (!Strings.isNullOrEmpty((String)overridingErrorMessage) && !diff.similar()) {
            this.failWithMessage(overridingErrorMessage);
        } else {
            diff.failIfDifferent(MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]));
        }
        return this;
    }

    private void failWithMessage(String errorMessage) {
        AssertionError assertionError = Failures.instance().failureIfErrorMessageIsOverridden((AssertionInfo)this.info);
        if (assertionError == null) {
            String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]);
            assertionError = new AssertionError((Object)(description + errorMessage));
        }
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        throw assertionError;
    }

    @NotNull
    public MapAssert<String, Object> isObject() {
        Node node = this.assertType(Node.NodeType.OBJECT);
        return (MapAssert)new JsonMapAssert((Map)node.getValue(), this.path.asPrefix(), this.configuration).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public BigDecimalAssert isNumber() {
        Node node = this.assertType(Node.NodeType.NUMBER);
        return this.createBigDecimalAssert(node.decimalValue());
    }

    public BigIntegerAssert isIntegralNumber() {
        Node node = this.internalMatcher.assertIntegralNumber();
        return (BigIntegerAssert)new BigIntegerAssert(node.decimalValue().toBigIntegerExact()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public BigDecimalAssert asNumber() {
        this.internalMatcher.isPresent(Node.NodeType.NUMBER.getDescription());
        Node node = JsonUtils.getNode((Object)this.actual, (String)"");
        if (node.getNodeType() == Node.NodeType.NUMBER) {
            return this.createBigDecimalAssert(node.decimalValue());
        }
        if (node.getNodeType() == Node.NodeType.STRING) {
            try {
                return this.createBigDecimalAssert(new BigDecimal(node.asText()));
            }
            catch (NumberFormatException e) {
                this.failWithMessage("Node \"" + this.path + "\" can not be converted to number expected: <a number> but was: <" + Diff.quoteTextValue((Object)node.getValue()) + ">.");
            }
        } else {
            this.internalMatcher.failOnType(node, "number or string");
        }
        return null;
    }

    private BigDecimalAssert createBigDecimalAssert(BigDecimal value) {
        return (BigDecimalAssert)new BigDecimalAssert(value).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public ListAssert<Object> isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return (ListAssert)new JsonListAssert((List)node.getValue(), this.path.asPrefix(), this.configuration).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public BooleanAssert isBoolean() {
        Node node = this.assertType(Node.NodeType.BOOLEAN);
        return (BooleanAssert)new BooleanAssert((Boolean)node.getValue()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public StringAssert isString() {
        Node node = this.assertType(Node.NodeType.STRING);
        return (StringAssert)new StringAssert((String)node.getValue()).as("Different value found in node \"%s\"", new Object[]{this.path});
    }

    @NotNull
    public AbstractStringAssert<?> asString() {
        return this.isString();
    }

    public void isNull() {
        this.assertType(Node.NodeType.NULL);
    }

    @NotNull
    public JsonAssert isPresent() {
        this.internalMatcher.isPresent();
        return this;
    }

    public void isAbsent() {
        this.internalMatcher.isAbsent();
    }

    @NotNull
    public JsonAssert isNotNull() {
        this.internalMatcher.isNotNull();
        return this;
    }

    private Node assertType(Node.NodeType type) {
        return this.internalMatcher.assertType(type);
    }

    public static class ConfigurableJsonAssert
    extends JsonAssert {
        private final Object originalActual;

        ConfigurableJsonAssert(Path path, Configuration configuration, Object actual) {
            super(path, configuration, actual);
            this.originalActual = actual;
        }

        ConfigurableJsonAssert(Object actual, Configuration configuration) {
            this(Path.create((String)"", (String)JsonUtils.getPathPrefix((Object)actual)), configuration, actual);
        }

        @NotNull
        public ConfigurableJsonAssert when(@NotNull Option first, Option ... other) {
            return this.withConfiguration(c -> c.when(first, other));
        }

        @NotNull
        public final ConfigurableJsonAssert when(@NotNull ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
            return this.withConfiguration(c -> c.when(object, actions));
        }

        @NotNull
        public ConfigurableJsonAssert withOptions(@NotNull Options options) {
            return this.withConfiguration(c -> c.withOptions(options));
        }

        @NotNull
        public ConfigurableJsonAssert withConfiguration(@NotNull Function<Configuration, Configuration> configurationFunction) {
            Configuration newConfiguration = configurationFunction.apply(this.configuration);
            newConfiguration = InternalJsonPathUtils.resolveJsonPaths((Object)this.originalActual, (Configuration)newConfiguration);
            return new ConfigurableJsonAssert(this.path, newConfiguration, this.actual);
        }

        @NotNull
        public ConfigurableJsonAssert withTolerance(@Nullable BigDecimal tolerance) {
            return this.withConfiguration(c -> c.withTolerance(tolerance));
        }

        @NotNull
        public ConfigurableJsonAssert withTolerance(double tolerance) {
            return this.withTolerance(BigDecimal.valueOf(tolerance));
        }

        @NotNull
        public ConfigurableJsonAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
            return this.withConfiguration(c -> c.whenIgnoringPaths(pathsToBeIgnored));
        }

        @NotNull
        public ConfigurableJsonAssert withIgnorePlaceholder(@NotNull String ignorePlaceholder) {
            return this.withConfiguration(c -> c.withIgnorePlaceholder(ignorePlaceholder));
        }

        @NotNull
        public ConfigurableJsonAssert withMatcher(@NotNull String matcherName, @NotNull Matcher<?> matcher) {
            return this.withConfiguration(c -> c.withMatcher(matcherName, matcher));
        }

        @NotNull
        public ConfigurableJsonAssert withDifferenceListener(@NotNull DifferenceListener differenceListener) {
            return this.withConfiguration(c -> c.withDifferenceListener(differenceListener));
        }

        @NotNull
        public JsonAssert inPath(@NotNull String jsonPath) {
            return new JsonAssert(JsonPathAdapter.inPath((Object)this.originalActual, (String)jsonPath), this.configuration);
        }

        @NotNull
        public ConfigurableJsonAssert describedAs(@NotNull Description description) {
            return (ConfigurableJsonAssert)super.describedAs(description);
        }

        @NotNull
        public ConfigurableJsonAssert describedAs(@NotNull String description, Object ... args) {
            return (ConfigurableJsonAssert)((Object)super.describedAs(description, args));
        }

        @NotNull
        public ConfigurableJsonAssert as(@NotNull Description description) {
            return (ConfigurableJsonAssert)((Object)super.as(description));
        }

        @NotNull
        public ConfigurableJsonAssert as(@NotNull String description, Object ... args) {
            return (ConfigurableJsonAssert)((Object)super.as(description, args));
        }
    }
}

