/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.Map;
import net.javacrumbs.jsonunit.assertj.JsonComparator;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.MapAssert;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.Failures;

class JsonMapAssert
extends MapAssert<String, Object> {
    private final Configuration configuration;
    private final Path path;
    private final Failures failures = Failures.instance();

    JsonMapAssert(Map<String, Object> actual, Path path, Configuration configuration) {
        super(actual);
        this.path = path;
        this.configuration = configuration;
        this.usingComparator(new JsonComparator(configuration, path.asPrefix(), true));
    }

    public JsonMapAssert isEqualTo(Object expected) {
        this.describedAs(null);
        Diff diff = Diff.create((Object)expected, (Object)this.actual, (String)"fullJson", (Path)this.path, (Configuration)this.configuration);
        if (!diff.similar()) {
            this.failWithMessage(diff.toString(), new Object[0]);
        }
        return this;
    }

    public MapAssert<String, Object> containsValue(Object expected) {
        if (expected instanceof Node) {
            if (!this.contains(expected)) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldContainValue.shouldContainValue((Object)this.actual, (Object)expected));
            }
            return this;
        }
        return (MapAssert)super.containsValue(expected);
    }

    public MapAssert<String, Object> doesNotContainValue(Object expected) {
        if (expected instanceof Node) {
            if (this.contains(expected)) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotContainValue.shouldNotContainValue((Object)this.actual, (Object)expected));
            }
            return this;
        }
        return (MapAssert)super.doesNotContainValue(expected);
    }

    private boolean contains(Object expected) {
        return ((Map)this.actual).entrySet().stream().anyMatch(kv -> Diff.create((Object)expected, kv.getValue(), (String)"fullJson", (Path)this.path.asPrefix(), (Configuration)this.configuration).similar());
    }
}

