/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springrx;

import java.util.concurrent.Future;
import net.javacrumbs.futureconverter.common.FutureWrapper;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.util.concurrent.SuccessCallback;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;

class ObservableListenableFuture<T>
extends FutureWrapper<T>
implements ListenableFuture<T> {
    private final Observable<T> observable;
    private final Subscription subscription;

    ObservableListenableFuture(Observable<T> observable) {
        super((Future)new SettableListenableFuture());
        this.observable = observable;
        this.subscription = observable.single().subscribe(new Action1<T>(){

            public void call(T t) {
                ObservableListenableFuture.this.getWrappedFuture().set(t);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                ObservableListenableFuture.this.getWrappedFuture().setException(throwable);
            }
        });
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.getWrappedFuture().addCallback(callback);
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.getWrappedFuture().addCallback(successCallback, failureCallback);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.subscription.unsubscribe();
        return super.cancel(mayInterruptIfRunning);
    }

    public Observable<T> getObservable() {
        return this.observable;
    }

    public SettableListenableFuture<T> getWrappedFuture() {
        return (SettableListenableFuture)super.getWrappedFuture();
    }
}

