/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.java8rx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.Subscription;

class ObservableCompletableFuture<T>
extends CompletableFuture<T> {
    private final Subscription subscription;
    private final Observable<T> observable;

    public ObservableCompletableFuture(Observable<T> observable) {
        this.subscription = observable.take(1).subscribe(this::complete, this::completeExceptionally);
        this.observable = observable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        this.subscription.unsubscribe();
        return result;
    }

    public Observable<T> getObservable() {
        return this.observable;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.checkSubscription();
        return super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkSubscription();
        return super.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        this.checkSubscription();
        return super.isCancelled();
    }

    @Override
    public boolean isDone() {
        this.checkSubscription();
        return super.isDone();
    }

    private void checkSubscription() {
        if (this.subscription.isUnsubscribed() && !super.isDone()) {
            this.completeExceptionally(new ExecutionException("Observable unsubscribed", null));
        }
    }
}

