/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.guavarx;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import rx.Observable;
import rx.Subscriber;

class ListenableFutureObservable<T>
extends Observable<T> {
    private final ListenableFuture<T> listenableFuture;

    ListenableFutureObservable(ListenableFuture<T> listenableFuture) {
        super(ListenableFutureObservable.onSubscribe(listenableFuture));
        this.listenableFuture = listenableFuture;
    }

    private static <T> Observable.OnSubscribe<T> onSubscribe(final ListenableFuture<T> listenableFuture) {
        return new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<T>(){

                    public void onSuccess(T result) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(result);
                            subscriber.onCompleted();
                        }
                    }

                    public void onFailure(Throwable t) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError(t);
                        }
                    }
                });
            }
        };
    }

    public ListenableFuture<T> getListenableFuture() {
        return this.listenableFuture;
    }
}

