/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMUtilities;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private Object obj;
    private String algorithm;
    private char[] password;
    private SecureRandom random;
    private Provider provider;

    public MiscPEMGenerator(Object object) {
        this.obj = object;
    }

    public MiscPEMGenerator(Object object, String string2, char[] cArray, SecureRandom secureRandom, Provider provider) {
        this.obj = object;
        this.algorithm = string2;
        this.password = cArray;
        this.random = secureRandom;
        this.provider = provider;
    }

    public MiscPEMGenerator(Object object, String string2, char[] cArray, SecureRandom secureRandom, String string3) throws NoSuchProviderException {
        this.obj = object;
        this.algorithm = string2;
        this.password = cArray;
        this.random = secureRandom;
        if (string3 != null) {
            this.provider = Security.getProvider(string3);
            if (this.provider == null) {
                throw new NoSuchProviderException("cannot find provider: " + string3);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject createPemObject(Object object) throws IOException {
        byte[] byArray;
        String string2;
        if (object instanceof PemObject) {
            return (PemObject)object;
        }
        if (object instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)object).generate();
        }
        if (object instanceof X509Certificate) {
            string2 = "CERTIFICATE";
            try {
                byArray = ((X509Certificate)object).getEncoded();
                return new PemObject(string2, byArray);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new PemGenerationException("Cannot encode object: " + certificateEncodingException.toString());
            }
        } else if (object instanceof X509CRL) {
            string2 = "X509 CRL";
            try {
                byArray = ((X509CRL)object).getEncoded();
                return new PemObject(string2, byArray);
            }
            catch (CRLException cRLException) {
                throw new PemGenerationException("Cannot encode object: " + cRLException.toString());
            }
        } else {
            if (object instanceof KeyPair) {
                return this.createPemObject(((KeyPair)object).getPrivate());
            }
            if (object instanceof PrivateKey) {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(((Key)object).getEncoded()));
                if (object instanceof RSAPrivateKey) {
                    string2 = "RSA PRIVATE KEY";
                    byArray = privateKeyInfo.getPrivateKey().getEncoded();
                    return new PemObject(string2, byArray);
                } else if (object instanceof DSAPrivateKey) {
                    string2 = "DSA PRIVATE KEY";
                    DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add(new DERInteger(0));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getP()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getQ()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getG()));
                    BigInteger bigInteger = ((DSAPrivateKey)object).getX();
                    BigInteger bigInteger2 = dSAParameter.getG().modPow(bigInteger, dSAParameter.getP());
                    aSN1EncodableVector.add(new DERInteger(bigInteger2));
                    aSN1EncodableVector.add(new DERInteger(bigInteger));
                    byArray = new DERSequence(aSN1EncodableVector).getEncoded();
                    return new PemObject(string2, byArray);
                } else {
                    if (!((PrivateKey)object).getAlgorithm().equals("ECDSA")) throw new IOException("Cannot identify private key");
                    string2 = "EC PRIVATE KEY";
                    byArray = privateKeyInfo.getPrivateKey().getEncoded();
                }
                return new PemObject(string2, byArray);
            } else if (object instanceof PublicKey) {
                string2 = "PUBLIC KEY";
                byArray = ((PublicKey)object).getEncoded();
                return new PemObject(string2, byArray);
            } else if (object instanceof X509AttributeCertificate) {
                string2 = "ATTRIBUTE CERTIFICATE";
                byArray = ((X509V2AttributeCertificate)object).getEncoded();
                return new PemObject(string2, byArray);
            } else if (object instanceof PKCS10CertificationRequest) {
                string2 = "CERTIFICATE REQUEST";
                byArray = ((PKCS10CertificationRequest)object).getEncoded();
                return new PemObject(string2, byArray);
            } else {
                if (!(object instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
                string2 = "PKCS7";
                byArray = ((ContentInfo)object).getEncoded();
            }
        }
        return new PemObject(string2, byArray);
    }

    private String getHexEncoded(byte[] byArray) throws IOException {
        byArray = Hex.encode(byArray);
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray);
    }

    private PemObject createPemObject(Object object, String string2, char[] cArray, SecureRandom secureRandom) throws IOException {
        Serializable serializable2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (object instanceof KeyPair) {
            return this.createPemObject(((KeyPair)object).getPrivate(), string2, cArray, secureRandom);
        }
        String string3 = null;
        byte[] byArray = null;
        if (object instanceof RSAPrivateCrtKey) {
            string3 = "RSA PRIVATE KEY";
            object5 = (RSAPrivateCrtKey)object;
            object4 = new RSAPrivateKeyStructure(object5.getModulus(), object5.getPublicExponent(), object5.getPrivateExponent(), object5.getPrimeP(), object5.getPrimeQ(), object5.getPrimeExponentP(), object5.getPrimeExponentQ(), object5.getCrtCoefficient());
            byArray = ((ASN1Encodable)object4).getEncoded();
        } else if (object instanceof DSAPrivateKey) {
            string3 = "DSA PRIVATE KEY";
            object5 = (DSAPrivateKey)object;
            object4 = object5.getParams();
            object3 = new ASN1EncodableVector();
            ((ASN1EncodableVector)object3).add(new DERInteger(0));
            ((ASN1EncodableVector)object3).add(new DERInteger(object4.getP()));
            ((ASN1EncodableVector)object3).add(new DERInteger(object4.getQ()));
            ((ASN1EncodableVector)object3).add(new DERInteger(object4.getG()));
            object2 = object5.getX();
            serializable2 = object4.getG().modPow((BigInteger)object2, object4.getP());
            ((ASN1EncodableVector)object3).add(new DERInteger((BigInteger)serializable2));
            ((ASN1EncodableVector)object3).add(new DERInteger((BigInteger)object2));
            byArray = new DERSequence((ASN1EncodableVector)object3).getEncoded();
        } else if (object instanceof PrivateKey && "ECDSA".equals(((PrivateKey)object).getAlgorithm())) {
            string3 = "EC PRIVATE KEY";
            object5 = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(((PrivateKey)object).getEncoded()));
            byArray = ((PrivateKeyInfo)object5).getPrivateKey().getEncoded();
        }
        if (string3 == null || byArray == null) {
            throw new IllegalArgumentException("Object type not supported: " + object.getClass().getName());
        }
        object5 = Strings.toUpperCase(string2);
        if (((String)object5).equals("DESEDE")) {
            object5 = "DES-EDE3-CBC";
        }
        int n = ((String)object5).startsWith("AES-") ? 16 : 8;
        object3 = new byte[n];
        secureRandom.nextBytes((byte[])object3);
        object2 = PEMUtilities.crypt(true, this.provider, byArray, cArray, (String)object5, (byte[])object3);
        serializable2 = new ArrayList<PemHeader>(2);
        serializable2.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        serializable2.add(new PemHeader("DEK-Info", (String)object5 + "," + this.getHexEncoded((byte[])object3)));
        return new PemObject(string3, (List)((Object)serializable2), (byte[])object2);
    }

    @Override
    public PemObject generate() throws PemGenerationException {
        try {
            if (this.algorithm != null) {
                return this.createPemObject(this.obj, this.algorithm, this.password, this.random);
            }
            return this.createPemObject(this.obj);
        }
        catch (IOException iOException) {
            throw new PemGenerationException("encoding exception: " + iOException.getMessage(), iOException);
        }
    }
}

