/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class IETFUtils {
    public static RDN[] rDNsFromString(String string2, X500NameStyle x500NameStyle) {
        X500NameTokenizer x500NameTokenizer = new X500NameTokenizer(string2);
        X500NameBuilder x500NameBuilder = new X500NameBuilder(x500NameStyle);
        while (x500NameTokenizer.hasMoreTokens()) {
            String string3 = x500NameTokenizer.nextToken();
            int n = string3.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = x500NameStyle.attrNameToOID(string4);
            if (string5.indexOf(43) > 0) {
                X500NameTokenizer x500NameTokenizer2 = new X500NameTokenizer(string5, '+');
                String string6 = x500NameTokenizer2.nextToken();
                Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
                Vector<String> vector2 = new Vector<String>();
                vector.addElement(aSN1ObjectIdentifier);
                vector2.addElement(string6);
                while (x500NameTokenizer2.hasMoreTokens()) {
                    String string7 = x500NameTokenizer2.nextToken();
                    int n2 = string7.indexOf(61);
                    String string8 = string7.substring(0, n2);
                    String string9 = string7.substring(n2 + 1);
                    vector.addElement(x500NameStyle.attrNameToOID(string8));
                    vector2.addElement(string9);
                }
                x500NameBuilder.addMultiValuedRDN(IETFUtils.toOIDArray(vector), IETFUtils.toValueArray(vector2));
                continue;
            }
            x500NameBuilder.addRDN(aSN1ObjectIdentifier, string5);
        }
        return x500NameBuilder.build().getRDNs();
    }

    private static String[] toValueArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i != stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector vector) {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[vector.size()];
        for (int i = 0; i != aSN1ObjectIdentifierArray.length; ++i) {
            aSN1ObjectIdentifierArray[i] = (ASN1ObjectIdentifier)vector.elementAt(i);
        }
        return aSN1ObjectIdentifierArray;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String string2, Hashtable hashtable) {
        if (Strings.toUpperCase(string2).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(string2.substring(4));
        }
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(string2);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)hashtable.get(Strings.toLowerCase(string2));
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown object id - " + string2 + " - passed to distinguished name");
        }
        return aSN1ObjectIdentifier;
    }

    public static ASN1Encodable valueFromHexString(String string2, int n) throws IOException {
        string2 = Strings.toLowerCase(string2);
        byte[] byArray = new byte[(string2.length() - n) / 2];
        for (int i = 0; i != byArray.length; ++i) {
            char c = string2.charAt(i * 2 + n);
            char c2 = string2.charAt(i * 2 + n + 1);
            byArray[i] = c < 'a' ? (byte)(c - 48 << 4) : (byte)(c - 97 + 10 << 4);
            if (c2 < 'a') {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | (byte)(c2 - 48));
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] | (byte)(c2 - 97 + 10));
        }
        return ASN1Object.fromByteArray(byArray);
    }

    public static void appendTypeAndValue(StringBuffer stringBuffer, AttributeTypeAndValue attributeTypeAndValue, Hashtable hashtable) {
        String string2 = (String)hashtable.get(attributeTypeAndValue.getType());
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(attributeTypeAndValue.getType().getId());
        }
        stringBuffer.append('=');
        stringBuffer.append(IETFUtils.valueToString(attributeTypeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable aSN1Encodable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (aSN1Encodable instanceof ASN1String && !(aSN1Encodable instanceof DERUniversalString)) {
            String string2 = ((ASN1String)((Object)aSN1Encodable)).getString();
            if (string2.length() > 0 && string2.charAt(0) == '#') {
                stringBuffer.append("\\" + string2);
            } else {
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append("#" + IETFUtils.bytesToString(Hex.encode(aSN1Encodable.getDERObject().getDEREncoded())));
        }
        int n = stringBuffer.length();
        int n2 = 0;
        if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '\\' && stringBuffer.charAt(1) == '#') {
            n2 += 2;
        }
        while (n2 != n) {
            if (stringBuffer.charAt(n2) == ',' || stringBuffer.charAt(n2) == '\"' || stringBuffer.charAt(n2) == '\\' || stringBuffer.charAt(n2) == '+' || stringBuffer.charAt(n2) == '=' || stringBuffer.charAt(n2) == '<' || stringBuffer.charAt(n2) == '>' || stringBuffer.charAt(n2) == ';') {
                stringBuffer.insert(n2, "\\");
                ++n2;
                ++n;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String bytesToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static String canonicalize(String string2) {
        ASN1Object aSN1Object;
        String string3 = Strings.toLowerCase(string2.trim());
        if (string3.length() > 0 && string3.charAt(0) == '#' && (aSN1Object = IETFUtils.decodeObject(string3)) instanceof ASN1String) {
            string3 = Strings.toLowerCase(((ASN1String)((Object)aSN1Object)).getString().trim());
        }
        string3 = IETFUtils.stripInternalSpaces(string3);
        return string3;
    }

    private static ASN1Object decodeObject(String string2) {
        try {
            return ASN1Object.fromByteArray(Hex.decode(string2.substring(1)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unknown encoding in name: " + iOException);
        }
    }

    public static String stripInternalSpaces(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() != 0) {
            char c = string2.charAt(0);
            stringBuffer.append(c);
            for (int i = 1; i < string2.length(); ++i) {
                char c2 = string2.charAt(i);
                if (c != ' ' || c2 != ' ') {
                    stringBuffer.append(c2);
                }
                c = c2;
            }
        }
        return stringBuffer.toString();
    }
}

