/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static final String formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatElements(null, elems, quote).toString();
    }

    public CharArrayBuffer formatElements(CharArrayBuffer buffer, HeaderElement[] elems, boolean quote) {
        if (elems == null) {
            throw new IllegalArgumentException("Header element array must not be null.");
        }
        int len = this.estimateElementsLen(elems);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i], quote);
        }
        return buffer;
    }

    protected int estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result2 = (elems.length - 1) * 2;
        for (int i = 0; i < elems.length; ++i) {
            result2 += this.estimateHeaderElementLen(elems[i]);
        }
        return result2;
    }

    public static final String formatHeaderElement(HeaderElement elem2, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeaderElement(null, elem2, quote).toString();
    }

    public CharArrayBuffer formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem2, boolean quote) {
        int parcnt;
        if (elem2 == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int len = this.estimateHeaderElementLen(elem2);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(elem2.getName());
        String value2 = elem2.getValue();
        if (value2 != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value2, quote);
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem2.getParameter(i), quote);
            }
        }
        return buffer;
    }

    protected int estimateHeaderElementLen(HeaderElement elem2) {
        int parcnt;
        if (elem2 == null) {
            return 0;
        }
        int result2 = elem2.getName().length();
        String value2 = elem2.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result2 += 2 + this.estimateNameValuePairLen(elem2.getParameter(i));
            }
        }
        return result2;
    }

    public static final String formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatParameters(null, nvps, quote).toString();
    }

    public CharArrayBuffer formatParameters(CharArrayBuffer buffer, NameValuePair[] nvps, boolean quote) {
        if (nvps == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        int len = this.estimateParametersLen(nvps);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i], quote);
        }
        return buffer;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result2 = (nvps.length - 1) * 2;
        for (int i = 0; i < nvps.length; ++i) {
            result2 += this.estimateNameValuePairLen(nvps[i]);
        }
        return result2;
    }

    public static final String formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatNameValuePair(null, nvp, quote).toString();
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote) {
        if (nvp == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int len = this.estimateNameValuePairLen(nvp);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value2 = nvp.getValue();
        if (value2 != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value2, quote);
        }
        return buffer;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result2 = nvp.getName().length();
        String value2 = nvp.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        return result2;
    }

    protected void doFormatValue(CharArrayBuffer buffer, String value2, boolean quote) {
        int i;
        if (!quote) {
            for (i = 0; i < value2.length() && !quote; ++i) {
                quote = this.isSeparator(value2.charAt(i));
            }
        }
        if (quote) {
            buffer.append('\"');
        }
        for (i = 0; i < value2.length(); ++i) {
            char ch = value2.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (quote) {
            buffer.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

