/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.java.truevfs.key.spec.param.KeyStrength;
import net.java.truevfs.key.swing.util.EnhancedPanel;

@NotThreadSafe
final class KeyStrengthPanel<S extends KeyStrength>
extends EnhancedPanel {
    private static final long serialVersionUID = 5629581723148235643L;
    private static final ResourceBundle resources = ResourceBundle.getBundle(KeyStrengthPanel.class.getName());
    private final S[] availableKeyStrengths;
    private final JComboBox keyStrength = new JComboBox();

    KeyStrengthPanel(S[] availableKeyStrenghts) {
        this.availableKeyStrengths = (KeyStrength[])availableKeyStrenghts.clone();
        this.initComponents();
    }

    private ComboBoxModel<S> newModel() {
        return new DefaultComboBoxModel<S>(this.availableKeyStrengths);
    }

    private void initComponents() {
        JLabel keyStrengthLong = new JLabel();
        JLabel keyStrengthShort = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyStrength.setModel(this.newModel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.keyStrength, gridBagConstraints);
        keyStrengthLong.setLabelFor(this.keyStrength);
        keyStrengthLong.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)keyStrengthLong, gridBagConstraints);
        keyStrengthShort.setLabelFor(this.keyStrength);
        keyStrengthShort.setText(resources.getString("keyStrength"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)keyStrengthShort, gridBagConstraints);
    }

    public S getKeyStrength() {
        return (S)((KeyStrength)this.keyStrength.getSelectedItem());
    }

    public void setKeyStrength(S keyStrength) {
        Objects.requireNonNull(keyStrength);
        this.keyStrength.setSelectedItem(keyStrength);
    }
}

