/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.tar.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.io.AbstractSink;
import net.java.truecommons.io.AbstractSource;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.tardriver.TarDriver;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.comp.tardriver.TarInputService;
import net.java.truevfs.comp.tardriver.TarOutputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.cio.OutputService;

@Immutable
public class TarGZipDriver
extends TarDriver {
    public int getBufferSize() {
        return 8192;
    }

    public int getLevel() {
        return 9;
    }

    @Override
    protected InputService<TarDriverEntry> newInput(FsModel model, final FsInputSocketSource source) throws IOException {
        final class Source
        extends AbstractSource {
            Source() {
            }

            @Override
            public InputStream stream() throws IOException {
                InputStream in = source.stream();
                try {
                    return new GZIPInputStream(in, TarGZipDriver.this.getBufferSize());
                }
                catch (Throwable ex) {
                    try {
                        in.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new TarInputService(model, new Source(), this);
    }

    @Override
    protected OutputService<TarDriverEntry> newOutput(FsModel model, final FsOutputSocketSink sink, InputService<TarDriverEntry> input2) throws IOException {
        final class Sink
        extends AbstractSink {
            Sink() {
            }

            @Override
            public OutputStream stream() throws IOException {
                OutputStream out = sink.stream();
                try {
                    return new GZIPOutputStream(out, TarGZipDriver.this.getBufferSize(), TarGZipDriver.this.getLevel());
                }
                catch (Throwable ex) {
                    try {
                        out.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new MultiplexingOutputService<TarDriverEntry>(this.getPool(), new TarOutputService(model, new Sink(), this));
    }

    @Override
    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        options = options.set(FsAccessOption.STORE);
        return new FsOutputSocketSink(options, controller2.output(options, name, null));
    }

    private static final class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        GZIPOutputStream(OutputStream out, int size2, int level) throws IOException {
            super(out, size2);
            this.def.setLevel(level);
        }
    }
}

