/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.driver.file.FileNode;
import net.java.truevfs.driver.file.IOExceptionOutputStream;
import net.java.truevfs.driver.file.IOExceptionSeekableChannel;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.cio.AbstractOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoSockets;

@NotThreadSafe
final class FileOutputSocket
extends AbstractOutputSocket<FileNode> {
    private static final int INITIAL_CAPACITY = HashMaps.initialCapacity(FsAccessOption.values().length);
    private static final StandardOpenOption[] WRITE_STANDARD_OPEN_OPTION = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
    private final BitField<FsAccessOption> options;
    private final FileNode node;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(BitField<FsAccessOption> options, FileNode node2, @CheckForNull Entry template) {
        assert (null != node2);
        this.node = node2;
        if (options.get(FsAccessOption.EXCLUSIVE) && options.get(FsAccessOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.options = options;
        this.template = template;
    }

    @Override
    public FileNode target() {
        return this.node;
    }

    private FileNode begin() throws IOException {
        Path parentFile;
        FileNode buffer;
        Path entryFile = this.node.getPath();
        Boolean exists2 = null;
        if (this.options.get(FsAccessOption.EXCLUSIVE) && (exists2 = Boolean.valueOf(Files.exists(entryFile, new LinkOption[0]))).booleanValue()) {
            throw new FileAlreadyExistsException(this.node.toString());
        }
        if (this.options.get(FsAccessOption.CACHE)) {
            if (Boolean.TRUE.equals(exists2) || null == exists2 && (exists2 = Boolean.valueOf(Files.exists(entryFile, new LinkOption[0]))).booleanValue()) {
                entryFile.getFileSystem().provider().checkAccess(entryFile, AccessMode.WRITE);
            } else {
                Files.createFile(entryFile, new FileAttribute[0]);
            }
            buffer = this.node.createIoBuffer();
        } else {
            buffer = this.node;
        }
        if (this.options.get(FsAccessOption.CREATE_PARENTS) && !Boolean.TRUE.equals(exists2) && null != (parentFile = entryFile.getParent())) {
            Files.createDirectories(parentFile, new FileAttribute[0]);
        }
        return buffer;
    }

    void append(FileNode buffer) throws IOException {
        if (buffer != this.node && this.options.get(FsAccessOption.APPEND) && Files.exists(this.node.getPath(), new LinkOption[0])) {
            IoSockets.copy(this.node.input(), buffer.output());
        }
    }

    Set<OpenOption> optionSet() {
        HashSet<OpenOption> set = new HashSet<OpenOption>(INITIAL_CAPACITY);
        Collections.addAll(set, WRITE_STANDARD_OPEN_OPTION);
        if (this.options.get(FsAccessOption.APPEND)) {
            set.add(StandardOpenOption.APPEND);
            set.remove(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.options.get(FsAccessOption.EXCLUSIVE)) {
            set.add(StandardOpenOption.CREATE_NEW);
        }
        return set;
    }

    OpenOption[] optionArray() {
        Set<OpenOption> set = this.optionSet();
        return set.toArray(new OpenOption[set.size()]);
    }

    void close(FileNode buffer, boolean commit2) throws IOException {
        Path entryFile = this.node.getPath();
        if (buffer != this.node) {
            Path bufferFile = buffer.getPath();
            this.updateProperties(bufferFile);
            if (commit2) {
                try {
                    Files.move(bufferFile, entryFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    IoSockets.copy(buffer.input(), this.node.output());
                    this.updateProperties(entryFile);
                }
                buffer.release();
            }
        } else {
            this.updateProperties(entryFile);
        }
    }

    private void updateProperties(Path file) throws IOException {
        Entry template = this.template;
        if (null == template) {
            return;
        }
        Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileOutputSocket.toFileTime(template.getTime(Entry.Access.WRITE)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.READ)), FileOutputSocket.toFileTime(template.getTime(Entry.Access.CREATE)));
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }

    IOException release(IOException ex, FileNode buffer) throws IOException {
        try {
            buffer.release();
        }
        catch (IOException ex2) {
            ex.addSuppressed(ex2);
        }
        return ex;
    }

    @Override
    public SeekableByteChannel channel(InputSocket<? extends Entry> peer) throws IOException {
        final FileNode buffer = this.begin();
        try {
            this.append(buffer);
            final class Channel
            extends IOExceptionSeekableChannel {
                boolean closed;

                Channel() throws IOException {
                    super(Files.newByteChannel(fileNode.getPath(), FileOutputSocket.this.optionSet(), new FileAttribute[0]));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(buffer, null == this.exception);
                }
            }
            return new Channel();
        }
        catch (IOException ex) {
            throw this.release(ex, buffer);
        }
    }

    @Override
    public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
        final FileNode buffer = this.begin();
        try {
            this.append(buffer);
            final class Stream
            extends IOExceptionOutputStream {
                boolean closed;

                @CreatesObligation
                Stream() throws IOException {
                    super(Files.newOutputStream(fileNode.getPath(), FileOutputSocket.this.optionArray()));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(buffer, null == this.exception);
                }
            }
            return new Stream();
        }
        catch (IOException ex) {
            throw this.release(ex, buffer);
        }
    }
}

