/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.services;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;

final class UnifiedClassLoader
extends ClassLoader {
    private final ClassLoader secondary;

    static ClassLoader resolve(final ClassLoader primary, final ClassLoader secondary) {
        assert (null != primary);
        assert (null != secondary);
        if (primary == secondary || UnifiedClassLoader.isChildOf(primary, secondary)) {
            return primary;
        }
        if (UnifiedClassLoader.isChildOf(secondary, primary)) {
            return secondary;
        }
        class NewUnifiedClassLoader
        implements PrivilegedAction<ClassLoader> {
            NewUnifiedClassLoader() {
            }

            @Override
            public ClassLoader run() {
                return new UnifiedClassLoader(primary, secondary);
            }
        }
        return AccessController.doPrivileged(new NewUnifiedClassLoader());
    }

    private static boolean isChildOf(ClassLoader c, ClassLoader r) {
        ClassLoader p;
        while (null != (p = c.getParent())) {
            if (p == r) {
                return true;
            }
            c = p;
        }
        return false;
    }

    private UnifiedClassLoader(ClassLoader primary, ClassLoader secondary) {
        super(primary);
        this.secondary = secondary;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.secondary.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.secondary.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.secondary.getResources(name);
    }
}

