/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.services;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.logging.BundledMessage;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.services.Container;
import net.java.truecommons.services.DecoratorService;
import net.java.truecommons.services.Factory;
import net.java.truecommons.services.FactoryService;
import net.java.truecommons.services.FactoryWithSomeFunctions;
import net.java.truecommons.services.Function;
import net.java.truecommons.services.FunctionService;
import net.java.truecommons.services.Loader;
import net.java.truecommons.services.ProviderService;
import net.java.truecommons.services.ProviderWithSomeFunctions;
import net.java.truecommons.services.ServiceComparator;
import net.java.truecommons.services.Store;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ThreadSafe
public final class Locator {
    private static final Logger logger = new LocalizedLogger(Locator.class);
    private static final Marker CONFIG = MarkerFactory.getMarker("CONFIG");
    private final Loader loader;

    public Locator(Class<?> client) {
        this.loader = new Loader(client.getClassLoader());
    }

    public <P> Factory<P> factory(Class<? extends FactoryService<P>> factory) throws ServiceConfigurationError {
        return this.factory(factory, null);
    }

    public <P> Factory<P> factory(Class<? extends FactoryService<P>> factory, @CheckForNull Class<? extends FunctionService<P>> functions) throws ServiceConfigurationError {
        FactoryService<P> p = this.provider(factory);
        FunctionService[] f2 = null == functions ? null : this.functions(functions);
        return null == f2 || 0 == f2.length ? p : new FactoryWithSomeFunctions<P>(p, (Function<P>[])f2);
    }

    public <P> Container<P> container(Class<? extends ProviderService<P>> provider) throws ServiceConfigurationError {
        return this.container(provider, null);
    }

    public <P> Container<P> container(Class<? extends ProviderService<P>> provider, @CheckForNull Class<? extends DecoratorService<P>> decorator) throws ServiceConfigurationError {
        ProviderService<P> p = this.provider(provider);
        DecoratorService[] d = null == decorator ? null : (DecoratorService[])this.functions(decorator);
        return new Store<P>(null == d || 0 == d.length ? p : new ProviderWithSomeFunctions<P>(p, d));
    }

    private <S extends ProviderService<?>> S provider(Class<S> spec) throws ServiceConfigurationError {
        ProviderService service = (ProviderService)this.loader.instanceOf(spec, null);
        if (null == service) {
            for (ProviderService newService : this.loader.instancesOf(spec)) {
                int np;
                logger.debug(CONFIG, "located", (Object)newService);
                if (null == service) {
                    service = newService;
                    continue;
                }
                int op = service.getPriority();
                if (op < (np = newService.getPriority())) {
                    service = newService;
                    continue;
                }
                if (op != np || service.getClass().getName().equals(newService.getClass().getName())) continue;
                logger.warn("collision", new Object[]{op, service, newService});
            }
        }
        if (null == service) {
            throw new ServiceConfigurationError(new BundledMessage(Locator.class, "null", spec).toString());
        }
        logger.debug(CONFIG, "selecting", (Object)service);
        return (S)service;
    }

    private <S extends FunctionService<?>> S[] functions(Class<S> spec) throws ServiceConfigurationError {
        LinkedList<FunctionService> c = new LinkedList<FunctionService>();
        for (FunctionService service : this.loader.instancesOf(spec)) {
            c.add(service);
        }
        FunctionService[] a = c.toArray((FunctionService[])Array.newInstance(spec, c.size()));
        Arrays.sort(a, new ServiceComparator());
        for (FunctionService service : a) {
            logger.debug(CONFIG, "selecting", (Object)service);
        }
        return a;
    }
}

