/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public final class PowerBuffer
implements Comparable<PowerBuffer> {
    private final ByteBuffer bb;

    private PowerBuffer(ByteBuffer bb) {
        this.bb = bb;
    }

    public static PowerBuffer allocateDirect(int capacity) {
        return new PowerBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static PowerBuffer allocate(int capacity) {
        return new PowerBuffer(ByteBuffer.allocate(capacity));
    }

    public static PowerBuffer wrap(byte[] array, int offset, int length) {
        return new PowerBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public static PowerBuffer wrap(byte[] array) {
        return PowerBuffer.wrap(array, 0, array.length);
    }

    public static PowerBuffer wrap(ByteBuffer buffer) {
        return new PowerBuffer(Objects.requireNonNull(buffer));
    }

    public ByteBuffer buffer() {
        return this.bb;
    }

    public PowerBuffer littleEndian() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public PowerBuffer bigEndian() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this;
    }

    public PowerBuffer load(ReadableByteChannel channel2) throws EOFException, IOException {
        int read2;
        int remaining = this.bb.remaining();
        this.bb.mark();
        do {
            if (0 <= (read2 = channel2.read(this.bb))) continue;
            throw new EOFException();
        } while (0 < (remaining -= read2));
        this.bb.reset();
        return this;
    }

    public PowerBuffer save(WritableByteChannel channel2) throws IOException {
        int remaining = this.bb.remaining();
        this.bb.mark();
        while (0 < (remaining -= channel2.write(this.bb))) {
        }
        this.bb.reset();
        return this;
    }

    public PowerBuffer skip(int skip) {
        this.bb.position(this.bb.position() + skip);
        return this;
    }

    public int getUByte() {
        return this.bb.get() & 0xFF;
    }

    public int getUByte(int index) {
        return this.bb.get(index) & 0xFF;
    }

    public int getUShort() {
        return this.bb.getShort() & 0xFFFF;
    }

    public int getUShort(int index) {
        return this.bb.getShort(index) & 0xFFFF;
    }

    public long getUInt() {
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    public long getUInt(int index) {
        return (long)this.bb.getInt(index) & 0xFFFFFFFFL;
    }

    public int position() {
        return this.bb.position();
    }

    public int limit() {
        return this.bb.limit();
    }

    public int capacity() {
        return this.bb.capacity();
    }

    public PowerBuffer position(int newPosition) {
        this.bb.position(newPosition);
        return this;
    }

    public PowerBuffer limit(int newLimit) {
        this.bb.limit(newLimit);
        return this;
    }

    public PowerBuffer mark() {
        this.bb.mark();
        return this;
    }

    public PowerBuffer reset() {
        this.bb.reset();
        return this;
    }

    public PowerBuffer clear() {
        this.bb.clear();
        return this;
    }

    public PowerBuffer flip() {
        this.bb.flip();
        return this;
    }

    public PowerBuffer rewind() {
        this.bb.rewind();
        return this;
    }

    public int remaining() {
        return this.bb.remaining();
    }

    public boolean hasRemaining() {
        return this.bb.hasRemaining();
    }

    public boolean isReadOnly() {
        return this.bb.isReadOnly();
    }

    public boolean hasArray() {
        return this.bb.hasArray();
    }

    public byte[] array() {
        return this.bb.array();
    }

    public int arrayOffset() {
        return this.bb.arrayOffset();
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public PowerBuffer slice() {
        return new PowerBuffer(this.bb.slice());
    }

    public PowerBuffer duplicate() {
        return new PowerBuffer(this.bb.duplicate());
    }

    public PowerBuffer asReadOnlyBuffer() {
        return new PowerBuffer(this.bb.asReadOnlyBuffer());
    }

    public byte get() {
        return this.bb.get();
    }

    public PowerBuffer put(byte b) {
        this.bb.put(b);
        return this;
    }

    public byte get(int index) {
        return this.bb.get(index);
    }

    public PowerBuffer put(int index, byte b) {
        this.bb.put(index, b);
        return this;
    }

    public PowerBuffer get(byte[] dst, int offset, int length) {
        this.bb.get(dst, offset, length);
        return this;
    }

    public PowerBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PowerBuffer put(PowerBuffer src) {
        this.bb.put(src.bb);
        return this;
    }

    public PowerBuffer put(byte[] src, int offset, int length) {
        this.bb.put(src, offset, length);
        return this;
    }

    public PowerBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public PowerBuffer compact() {
        this.bb.compact();
        return this;
    }

    public String toString() {
        return String.format("%s[position=%d, limit=%d, capacity=%d]", this.getClass().getName(), this.position(), this.limit(), this.capacity());
    }

    @Override
    public int compareTo(PowerBuffer that) {
        return this.bb.compareTo(that.bb);
    }

    public int hashCode() {
        return this.bb.hashCode();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof PowerBuffer && this.bb.equals(((PowerBuffer)that).bb);
    }

    public ByteOrder order() {
        return this.bb.order();
    }

    public PowerBuffer order(ByteOrder order) {
        this.bb.order(order);
        return this;
    }

    public char getChar() {
        return this.bb.getChar();
    }

    public PowerBuffer putChar(char value2) {
        this.bb.putChar(value2);
        return this;
    }

    public char getChar(int index) {
        return this.bb.getChar(index);
    }

    public PowerBuffer putChar(int index, char value2) {
        this.bb.putChar(index, value2);
        return this;
    }

    public CharBuffer asCharBuffer() {
        return this.bb.asCharBuffer();
    }

    public short getShort() {
        return this.bb.getShort();
    }

    public PowerBuffer putShort(short value2) {
        this.bb.putShort(value2);
        return this;
    }

    public short getShort(int index) {
        return this.bb.getShort(index);
    }

    public PowerBuffer putShort(int index, short value2) {
        this.bb.putShort(index, value2);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        return this.bb.asShortBuffer();
    }

    public int getInt() {
        return this.bb.getInt();
    }

    public PowerBuffer putInt(int value2) {
        this.bb.putInt(value2);
        return this;
    }

    public int getInt(int index) {
        return this.bb.getInt(index);
    }

    public PowerBuffer putInt(int index, int value2) {
        this.bb.putInt(index, value2);
        return this;
    }

    public IntBuffer asIntBuffer() {
        return this.bb.asIntBuffer();
    }

    public long getLong() {
        return this.bb.getLong();
    }

    public PowerBuffer putLong(long value2) {
        this.bb.putLong(value2);
        return this;
    }

    public long getLong(int index) {
        return this.bb.getLong(index);
    }

    public PowerBuffer putLong(int index, long value2) {
        this.bb.putLong(index, value2);
        return this;
    }

    public LongBuffer asLongBuffer() {
        return this.bb.asLongBuffer();
    }

    public float getFloat() {
        return this.bb.getFloat();
    }

    public PowerBuffer putFloat(float value2) {
        this.bb.putFloat(value2);
        return this;
    }

    public float getFloat(int index) {
        return this.bb.getFloat(index);
    }

    public PowerBuffer putFloat(int index, float value2) {
        this.bb.putFloat(index, value2);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        return this.bb.asFloatBuffer();
    }

    public double getDouble() {
        return this.bb.getDouble();
    }

    public PowerBuffer putDouble(double value2) {
        this.bb.putDouble(value2);
        return this;
    }

    public double getDouble(int index) {
        return this.bb.getDouble(index);
    }

    public PowerBuffer putDouble(int index, double value2) {
        this.bb.putDouble(index, value2);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.bb.asDoubleBuffer();
    }
}

