/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.NonWritableChannelException;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.AbstractSeekableChannel;

@NotThreadSafe
public final class ByteBufferChannel
extends AbstractSeekableChannel {
    private ByteBuffer buffer;
    private long position;
    private boolean closed;

    public ByteBufferChannel(ByteBuffer buffer) {
        if (!buffer.isReadOnly() && !buffer.hasArray()) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer.duplicate();
    }

    public ByteBuffer bufferDuplicate() {
        return this.buffer.duplicate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int srcLimit;
        this.checkOpen();
        int remaining = dst.remaining();
        if (remaining <= 0) {
            return 0;
        }
        long position = this.position;
        if (position >= (long)this.buffer.limit()) {
            return -1;
        }
        this.buffer.position((int)position);
        int available = this.buffer.remaining();
        if (available > remaining) {
            srcLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + remaining);
        } else {
            srcLimit = -1;
            remaining = available;
        }
        try {
            dst.put(this.buffer);
        }
        finally {
            if (srcLimit >= 0) {
                this.buffer.limit(srcLimit);
            }
        }
        this.position += (long)remaining;
        return remaining;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        int remaining = src.remaining();
        long minLimit = this.position + (long)remaining;
        int limit = this.buffer.limit();
        if (minLimit > (long)limit) {
            long oldCapacity = this.buffer.capacity();
            if (minLimit <= oldCapacity) {
                this.buffer.limit((int)minLimit);
            } else {
                long newCapacity;
                if (minLimit > Integer.MAX_VALUE) {
                    throw new OutOfMemoryError();
                }
                if (this.buffer.isReadOnly()) {
                    throw new NonWritableChannelException();
                }
                long l = newCapacity = 0L < oldCapacity ? oldCapacity : 1L;
                while ((newCapacity <<= 1) < minLimit) {
                }
                if (newCapacity > Integer.MAX_VALUE) {
                    newCapacity = minLimit;
                }
                byte[] array = new byte[(int)newCapacity];
                System.arraycopy(this.buffer.array(), this.buffer.arrayOffset(), array, 0, limit);
                this.buffer = ByteBuffer.wrap(array);
            }
            long position = this.position;
            assert (position <= Integer.MAX_VALUE);
            this.buffer.position((int)position);
        }
        try {
            this.buffer.put(src);
        }
        catch (ReadOnlyBufferException ex) {
            throw new NonWritableChannelException();
        }
        this.position += (long)remaining;
        return remaining;
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    @Override
    public ByteBufferChannel position(long position) throws IOException {
        this.checkOpen();
        if (0L > position) {
            throw new IllegalArgumentException();
        }
        this.position = position;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.buffer.limit();
    }

    @Override
    public ByteBufferChannel truncate(long size2) throws IOException {
        this.checkOpen();
        if (this.buffer.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        if ((long)this.buffer.limit() > size2) {
            this.buffer.limit((int)size2);
        }
        if (this.position > size2) {
            this.position = size2;
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @DischargesObligation
    public void close() {
        this.closed = true;
    }
}

