/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.truevfs.key.spec.param.SafePbeParameters;
import net.java.truevfs.key.swing.AuthenticationPanel;
import net.java.truevfs.key.swing.KeyPanel;
import net.java.truevfs.key.swing.SwingSafePbeParametersView;
import net.java.truevfs.key.swing.WeakKeyException;
import net.java.truevfs.key.swing.util.EnhancedPanel;
import net.java.truevfs.key.swing.util.PanelEvent;
import net.java.truevfs.key.swing.util.PanelListener;

final class WriteKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 6416529465492387235L;
    private static final String CLASS_NAME = WriteKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final int MIN_PASSWD_LEN = 8;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private final AuthenticationPanel authenticationPanel = new AuthenticationPanel();
    private final JLabel error = new JLabel();
    private final JPasswordField newPasswd1Field = new JPasswordField();
    private final JPasswordField newPasswd2Field = new JPasswordField();
    private final JTextPane resource = new JTextPane();

    WriteKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WriteKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1Field.getDocument().addDocumentListener(dl);
        this.newPasswd2Field.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setResource(URI resource) {
        URI lastResource = SwingSafePbeParametersView.lastResource;
        if (!lastResource.equals(resource) && !lastResource.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        SwingSafePbeParametersView.lastResource = resource;
    }

    @Override
    public String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    @Override
    public void setError(String error) {
        this.error.setText(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    boolean updateParam(SafePbeParameters<?, ?> param2) {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] newPasswd1 = this.newPasswd1Field.getPassword();
                    char[] newPasswd2 = this.newPasswd2Field.getPassword();
                    try {
                        if (Arrays.equals(newPasswd1, newPasswd2)) {
                            this.checkPasswdKey(newPasswd1);
                            this.setError(null);
                            param2.setPassword(newPasswd1);
                            boolean bl = true;
                            return bl;
                        }
                        this.setError(resources.getString("passwd.noMatch"));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        Arrays.fill(newPasswd1, '\u0000');
                        Arrays.fill(newPasswd2, '\u0000');
                    }
                }
                case 1: {
                    byte[] key;
                    File keyFile = this.authenticationPanel.getKeyFile();
                    if (keyFile.canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return false;
                    }
                    try {
                        key = SwingSafePbeParametersView.readKeyFile(keyFile);
                    }
                    catch (FileNotFoundException ex) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return false;
                    }
                    catch (EOFException ex) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return false;
                    }
                    catch (IOException ex) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return false;
                    }
                    this.checkKeyFileKey(key);
                    this.setError(null);
                    param2.setKeyFileBytes(key);
                    Arrays.fill(key, (byte)0);
                    return true;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException failure2) {
            this.setError(failure2.getLocalizedMessage());
            return false;
        }
    }

    protected void checkKeyFileKey(byte[] key) throws WeakKeyException {
        Deflater def = new Deflater();
        def.setInput(key);
        def.finish();
        assert (def.getTotalOut() == 0);
        int n = def.deflate(new byte[key.length * 2]);
        assert (def.getTotalOut() == n);
        def.end();
        if (n < 64) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    protected void checkPasswdKey(char[] key) throws WeakKeyException {
        if (8 > key.length) {
            throw new WeakKeyException(WriteKeyPanel.localizedMessage(resources, "passwd.tooShort", 8));
        }
    }

    private static String localizedMessage(ResourceBundle resources2, String key, @CheckForNull Object param2) {
        return param2 != null ? MessageFormat.format(resources2.getString(key), param2) : resources2.getString(key);
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    private void initComponents() {
        EnhancedPanel passwdPanel = new EnhancedPanel();
        JLabel newPasswd1Label = new JLabel();
        JLabel newPasswd2Label = new JLabel();
        JLabel prompt = new JLabel();
        passwdPanel.addPanelListener(new PanelListener(){

            @Override
            public void ancestorWindowShown(PanelEvent evt) {
                WriteKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            @Override
            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        passwdPanel.setLayout(new GridBagLayout());
        newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        newPasswd1Label.setLabelFor(this.newPasswd1Field);
        newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        passwdPanel.add((Component)newPasswd1Label, gridBagConstraints);
        this.newPasswd1Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        passwdPanel.add((Component)this.newPasswd1Field, gridBagConstraints);
        newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        newPasswd2Label.setLabelFor(this.newPasswd2Field);
        newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        passwdPanel.add((Component)newPasswd2Label, gridBagConstraints);
        this.newPasswd2Field.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        passwdPanel.add((Component)this.newPasswd2Field, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WriteKeyPanel.this.newPasswd1Field.requestFocusInWindow()) {
                            WriteKeyPanel.this.newPasswd1Field.selectAll();
                            WriteKeyPanel.this.newPasswd2Field.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

