/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.swing;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Provider;
import javax.swing.JOptionPane;
import net.java.truecommons.services.Loader;
import net.java.truevfs.key.spec.KeyPromptingInterruptedException;
import net.java.truevfs.key.spec.PromptingKeyProvider;
import net.java.truevfs.key.spec.UnknownKeyException;
import net.java.truevfs.key.spec.param.KeyStrength;
import net.java.truevfs.key.spec.param.SafePbeParameters;
import net.java.truevfs.key.spec.param.SafePbeParametersView;
import net.java.truevfs.key.swing.KeyStrengthPanel;
import net.java.truevfs.key.swing.ReadKeyPanel;
import net.java.truevfs.key.swing.WriteKeyPanel;
import net.java.truevfs.key.swing.feedback.Feedback;
import net.java.truevfs.key.swing.sl.InvalidKeyFeedbackLocator;
import net.java.truevfs.key.swing.sl.UnknownKeyFeedbackLocator;
import net.java.truevfs.key.swing.util.Windows;

@ThreadSafe
abstract class SwingSafePbeParametersView<P extends SafePbeParameters<P, S>, S extends KeyStrength>
extends SafePbeParametersView<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(SwingSafePbeParametersView.class.getName());
    static final URI INITIAL_RESOURCE = URI.create("");
    public static final int KEY_FILE_LEN = 512;
    private static final Map<URI, ReadKeyPanel> readKeyPanels = new WeakHashMap<URI, ReadKeyPanel>();
    private static final Loader loader = new Loader(SwingSafePbeParametersView.class.getClassLoader());
    static volatile URI lastResource = INITIAL_RESOURCE;
    private volatile Provider<Feedback> unknownKeyFeedbackProvider = UnknownKeyFeedbackLocator.SINGLETON;
    private volatile Provider<Feedback> invalidKeyFeedbackProvider = InvalidKeyFeedbackLocator.SINGLETON;

    SwingSafePbeParametersView() {
    }

    static byte[] readKeyFile(File file) throws FileNotFoundException, EOFException, IOException {
        byte[] buf = new byte[512];
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            raf.readFully(buf);
        }
        return buf;
    }

    Provider<Feedback> getUnknownKeyFeedbackProvider() {
        return this.unknownKeyFeedbackProvider;
    }

    void setUnkownKeyFeedbackProvider(Provider<Feedback> provider) {
        this.unknownKeyFeedbackProvider = provider;
    }

    Provider<Feedback> getInvalidKeyFeedbackProvider() {
        return this.invalidKeyFeedbackProvider;
    }

    void setInvalidKeyFeedback(Provider<Feedback> provider) {
        this.invalidKeyFeedbackProvider = provider;
    }

    @Override
    public void promptWriteKey(final PromptingKeyProvider.Controller<P> controller2) throws UnknownKeyException {
        class PromptWriteKey
        implements Runnable {
            PromptWriteKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptWriteKeyEDT(controller2);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptWriteKey());
    }

    private void promptWriteKeyEDT(PromptingKeyProvider.Controller<P> controller2) {
        assert (EventQueue.isDispatchThread());
        URI resource = controller2.getResource();
        assert (null != resource);
        SafePbeParameters param2 = (SafePbeParameters)controller2.getKey();
        if (null == param2) {
            param2 = this.newPbeParameters();
        }
        KeyStrengthPanel keyStrengthPanel = new KeyStrengthPanel(param2.getKeyStrengthValues());
        keyStrengthPanel.setKeyStrength(param2.getKeyStrength());
        WriteKeyPanel keyPanel = new WriteKeyPanel();
        keyPanel.setExtraDataUI(keyStrengthPanel);
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(null != keyPanel.getError() ? this.getInvalidKeyFeedbackProvider().get() : this.getUnknownKeyFeedbackProvider().get());
            int result2 = JOptionPane.showConfirmDialog(parent, keyPanel, resources.getString("writeKeyDialog.title"), 2, 3);
            if (result2 != 0) break;
            if (keyPanel.updateParam(param2)) {
                param2.setKeyStrength(keyStrengthPanel.getKeyStrength());
                controller2.setKey(param2);
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    @Override
    public void promptReadKey(final PromptingKeyProvider.Controller<P> controller2, final boolean invalid) throws UnknownKeyException {
        class PromptReadKey
        implements Runnable {
            PromptReadKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptReadKeyEDT(controller2, invalid);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptReadKey());
    }

    private void promptReadKeyEDT(PromptingKeyProvider.Controller<P> controller2, boolean invalid) {
        ReadKeyPanel keyPanel;
        assert (EventQueue.isDispatchThread());
        URI resource = controller2.getResource();
        assert (null != resource);
        Object param2 = this.newPbeParameters();
        if (invalid) {
            ReadKeyPanel panel = readKeyPanels.get(resource);
            keyPanel = panel != null ? panel : new ReadKeyPanel();
            keyPanel.setError(resources.getString("invalidKey"));
        } else {
            keyPanel = new ReadKeyPanel();
        }
        readKeyPanels.put(resource, keyPanel);
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback(null != keyPanel.getError() ? this.getInvalidKeyFeedbackProvider().get() : this.getUnknownKeyFeedbackProvider().get());
            int result2 = JOptionPane.showConfirmDialog(parent, keyPanel, resources.getString("readKeyDialog.title"), 2, 3);
            if (result2 != 0) {
                controller2.setKey(null);
                break;
            }
            if (keyPanel.updateParam((SafePbeParameters<?, ?>)param2)) {
                controller2.setKey(param2);
                controller2.setChangeRequested(keyPanel.isChangeKeySelected());
                break;
            }
            assert (keyPanel.getError() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable task) throws UnknownKeyException {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        Class<SwingSafePbeParametersView> clazz = SwingSafePbeParametersView.class;
        synchronized (SwingSafePbeParametersView.class) {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InterruptedException interrupt) {
                throw new KeyPromptingInterruptedException(interrupt);
            }
            catch (InvocationTargetException failure2) {
                throw new UnknownKeyException(failure2);
            }
            return;
        }
    }
}

