/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.spec;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.key.spec.KeyManager;
import net.java.truevfs.key.spec.SafeKey;
import net.java.truevfs.key.spec.SafeKeyProvider;

@ThreadSafe
public abstract class SafeKeyManager<K extends SafeKey<K>, P extends SafeKeyProvider<K>>
extends KeyManager<K> {
    private final Map<URI, P> providers = new HashMap<URI, P>();

    protected SafeKeyManager() {
    }

    protected abstract P newKeyProvider();

    public synchronized P make(URI resource) {
        SafeKeyProvider<Object> provider = (SafeKeyProvider)this.providers.get(Objects.requireNonNull(resource));
        if (null == provider) {
            provider = this.newKeyProvider();
            this.providers.put(resource, provider);
        }
        return (P)provider;
    }

    @CheckForNull
    public synchronized P get(URI resource) {
        return (P)((SafeKeyProvider)this.providers.get(Objects.requireNonNull(resource)));
    }

    @CheckForNull
    public synchronized P move(URI oldResource, URI newResource) {
        if (oldResource.equals(Objects.requireNonNull(newResource))) {
            throw new IllegalArgumentException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(oldResource);
        if (null != provider) {
            return (P)this.providers.put(newResource, provider);
        }
        return (P)((SafeKeyProvider)this.providers.remove(newResource));
    }

    @CheckForNull
    public synchronized P delete(URI resource) {
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(Objects.requireNonNull(resource));
        if (null != provider) {
            provider.setKey(null);
        }
        return (P)provider;
    }
}

