/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import javax.annotation.CheckForNull;
import net.java.truecommons.shed.BitField;

public interface Entry {
    public static final byte UNKNOWN = -1;
    public static final BitField<Type> NO_TYPES = BitField.noneOf(Type.class);
    public static final BitField<Type> ALL_TYPES = BitField.allOf(Type.class);
    public static final BitField<Type> FILE_TYPE = BitField.of(Type.FILE);
    public static final BitField<Type> DIRECTORY_TYPE = BitField.of(Type.DIRECTORY);
    public static final BitField<Type> SYMLINK_TYPE = BitField.of(Type.SYMLINK);
    public static final BitField<Type> SPECIAL_TYPE = BitField.of(Type.SPECIAL);
    public static final BitField<Size> NO_SIZES = BitField.noneOf(Size.class);
    public static final BitField<Size> ALL_SIZES = BitField.allOf(Size.class);
    public static final BitField<Access> NO_ACCESS = BitField.noneOf(Access.class);
    public static final BitField<Access> ALL_ACCESS = BitField.allOf(Access.class);
    public static final BitField<Access> ALL_POSIX_ACCESS = BitField.of((Enum)Access.READ, (Enum[])new Access[]{Access.WRITE, Access.EXECUTE});
    public static final BitField<PosixEntity> NO_POSIX_ENTITIES = BitField.noneOf(PosixEntity.class);
    public static final BitField<PosixEntity> ALL_POSIX_ENTITIES = BitField.allOf(PosixEntity.class);

    public String getName();

    public long getSize(Size var1);

    public long getTime(Access var1);

    @CheckForNull
    public Boolean isPermitted(Access var1, Entity var2);

    public static enum PosixEntity implements Entity
    {
        USER,
        GROUP,
        OTHER;

    }

    public static interface Entity {
    }

    public static enum Access {
        CREATE,
        READ,
        WRITE,
        EXECUTE,
        DELETE;

    }

    public static enum Size {
        DATA,
        STORAGE;

    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SYMLINK,
        SPECIAL;

    }
}

