/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.FilteringIterator;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDecoratingManager;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMountPoint;

@ThreadSafe
public final class FsFilteringManager
extends FsDecoratingManager {
    private final URI prefix;

    public FsFilteringManager(FsMountPoint prefix, FsManager manager) {
        super(manager);
        this.prefix = prefix.getHierarchicalUri();
    }

    @Override
    public int size() {
        int size2 = 0;
        for (FsController controller2 : this) {
            ++size2;
        }
        return size2;
    }

    @Override
    public Iterator<FsController> iterator() {
        return new FilteredControllerIterator();
    }

    private final class FilteredControllerIterator
    extends FilteringIterator<FsController> {
        final String ps;
        final String pp;
        final int ppl;
        final boolean pps;

        FilteredControllerIterator() {
            super(FsFilteringManager.this.manager.iterator());
            this.ps = FsFilteringManager.this.prefix.getScheme();
            this.pp = FsFilteringManager.this.prefix.getPath();
            this.ppl = this.pp.length();
            this.pps = '/' == this.pp.charAt(this.ppl - 1);
        }

        @Override
        protected boolean accept(FsController controller2) {
            String mpp;
            assert (null != controller2) : "null elements are not allowed in this collection!";
            URI mp = controller2.getModel().getMountPoint().getHierarchicalUri();
            return mp.getScheme().equals(this.ps) && (mpp = mp.getPath()).startsWith(this.pp) && (this.pps || mpp.length() == this.ppl || '/' == mpp.charAt(this.ppl));
        }
    }
}

