/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.http;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truevfs.driver.http.HttpController;
import net.java.truevfs.driver.http.HttpNode;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.sl.IoBufferPoolLocator;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

@Immutable
public class HttpDriver
extends FsDriver {
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private volatile HttpClient client;

    final IoBufferPool getPool() {
        return IoBufferPoolLocator.SINGLETON.get();
    }

    protected final HttpClient getClient() {
        HttpClient client = this.client;
        return null != client ? client : (this.client = this.newClient());
    }

    protected HttpClient newClient() {
        return new DefaultHttpClient(new PoolingClientConnectionManager());
    }

    protected HttpResponse executeHead(HttpNode entry2) throws IOException {
        return this.getClient().execute(entry2.newHead());
    }

    protected HttpResponse executeGet(HttpNode entry2) throws IOException {
        return this.getClient().execute(entry2.newGet());
    }

    @Override
    public FsController newController(FsManager manager, FsModel model, @CheckForNull FsController parent) {
        assert (null == parent);
        return new HttpController(this, model);
    }
}

