/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipKeyException;
import net.java.truevfs.comp.zip.ZipParameters;
import net.java.truevfs.comp.zip.ZipParametersProvider;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.key.spec.KeyManager;
import net.java.truevfs.key.spec.KeyProvider;
import net.java.truevfs.key.spec.UnknownKeyException;
import net.java.truevfs.key.spec.param.AesKeyStrength;
import net.java.truevfs.key.spec.param.AesPbeParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;

@ThreadSafe
public class KeyManagerZipCryptoParameters
implements ZipParametersProvider,
ZipCryptoParameters {
    private final AbstractZipDriver<?> driver;
    private final FsModel model;
    protected final Charset charset;

    public KeyManagerZipCryptoParameters(AbstractZipDriver<?> driver, FsModel model, Charset charset) {
        this.driver = Objects.requireNonNull(driver);
        this.model = Objects.requireNonNull(model);
        this.charset = Objects.requireNonNull(charset);
    }

    @Override
    public <P extends ZipParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(WinZipAesParameters.class)) {
            return (P)((ZipParameters)type.cast(new WinZipAes()));
        }
        return null;
    }

    protected byte[] password(char[] characters2, String name) {
        return PBEParametersGenerator.PKCS5PasswordToBytes(characters2);
    }

    private <K> KeyManager<K> keyManager(Class<K> type) {
        KeyManager<K> km = this.driver.getKeyManagerContainer().keyManager(type);
        if (null == km) {
            throw new ServiceConfigurationError("No key manager available for " + type + ".");
        }
        return km;
    }

    private URI resourceUri(String name) {
        return this.driver.fileSystemUri(this.model, name);
    }

    private class WinZipAes
    implements WinZipAesParameters {
        final KeyManager<AesPbeParameters> manager;

        private WinZipAes() {
            this.manager = KeyManagerZipCryptoParameters.this.keyManager(AesPbeParameters.class);
        }

        @Override
        public byte[] getWritePassword(String name) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.make(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(provider.getWriteKey().getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public byte[] getReadPassword(String name, boolean invalid) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.make(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(provider.getReadKey(invalid).getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public AesKeyStrength getKeyStrength(String name) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.make(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return (AesKeyStrength)provider.getWriteKey().getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public void setKeyStrength(String name, AesKeyStrength keyStrength) throws ZipKeyException {
            AesPbeParameters param2;
            KeyProvider<AesPbeParameters> provider = this.manager.make(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                param2 = provider.getReadKey(false);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
            param2.setKeyStrength(keyStrength);
            provider.setKey(param2);
        }
    }
}

