/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingInputStream;

@NotThreadSafe
final class CountingInputStream
extends DecoratingInputStream {
    private long bytesRead;

    @CreatesObligation
    CountingInputStream(@Nullable @WillCloseWhenClosed InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read2 = this.in.read(b, off, len);
        if (read2 > 0) {
            this.bytesRead += (long)read2;
        }
        return read2;
    }

    @Override
    public int read() throws IOException {
        int read2 = this.in.read();
        if (read2 != -1) {
            ++this.bytesRead;
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.bytesRead += skipped;
        return skipped;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

