/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@Immutable
public final class JmxUtils {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    public static boolean register(ObjectName name, Object mbean) {
        try {
            mbs.registerMBean(mbean, name);
            return true;
        }
        catch (InstanceAlreadyExistsException ignored) {
            return false;
        }
        catch (JMException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static boolean deregister(ObjectName name) {
        try {
            mbs.unregisterMBean(name);
            return true;
        }
        catch (InstanceNotFoundException ignored) {
            return false;
        }
        catch (JMException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Set<ObjectName> query(ObjectName name) {
        return mbs.queryNames(name, null);
    }

    public static <T> T proxy(ObjectName name, Class<T> type) {
        return JMX.newMBeanProxy(mbs, name, type);
    }

    private JmxUtils() {
    }
}

