/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.swing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.truevfs.key.spec.param.SafePbeParameters;
import net.java.truevfs.key.swing.AuthenticationPanel;
import net.java.truevfs.key.swing.KeyPanel;
import net.java.truevfs.key.swing.SwingSafePbeParametersView;
import net.java.truevfs.key.swing.util.EnhancedPanel;
import net.java.truevfs.key.swing.util.PanelEvent;
import net.java.truevfs.key.swing.util.PanelListener;

final class ReadKeyPanel
extends KeyPanel {
    private static final long serialVersionUID = 984673974236493651L;
    private static final String CLASS_NAME = ReadKeyPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private final Color defaultForeground;
    private final AuthenticationPanel authenticationPanel = new AuthenticationPanel();
    private final JCheckBox changeKey = new JCheckBox();
    private final JLabel error = new JLabel();
    private final JPasswordField passwdField = new JPasswordField();
    JTextPane resource;

    ReadKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReadKeyPanel.this.setError(null);
            }
        };
        this.passwdField.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resource.getForeground();
    }

    @Override
    public URI getResource() {
        return URI.create(this.resource.getText());
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setResource(URI resource) {
        URI lastResource = SwingSafePbeParametersView.lastResource;
        if (!lastResource.equals(resource) && !lastResource.equals(SwingSafePbeParametersView.INITIAL_RESOURCE)) {
            this.resource.setForeground(Color.RED);
        } else {
            this.resource.setForeground(this.defaultForeground);
        }
        this.resource.setText(resource.toString());
        SwingSafePbeParametersView.lastResource = resource;
    }

    @Override
    public String getError() {
        String error = this.error.getText();
        return error.isEmpty() ? null : error;
    }

    @Override
    public void setError(String error) {
        this.error.setText(error);
    }

    @Override
    boolean updateParam(SafePbeParameters<?, ?> param2) {
        switch (this.authenticationPanel.getAuthenticationMethod()) {
            case 0: {
                char[] passwd = this.passwdField.getPassword();
                param2.setPassword(passwd);
                Arrays.fill(passwd, '\u0000');
                return true;
            }
            case 1: {
                File keyFile = this.authenticationPanel.getKeyFile();
                try {
                    byte[] key = SwingSafePbeParametersView.readKeyFile(keyFile);
                    param2.setKeyFileBytes(key);
                    Arrays.fill(key, (byte)0);
                    return true;
                }
                catch (FileNotFoundException ex) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return false;
                }
                catch (EOFException ex) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return false;
                }
                catch (IOException ex) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return false;
                }
            }
        }
        throw new AssertionError((Object)"Unsupported authentication method!");
    }

    public boolean isChangeKeySelected() {
        return this.changeKey.isSelected();
    }

    public void setChangeKeySelected(boolean changeKeySelected) {
        this.changeKey.setSelected(changeKeySelected);
    }

    private void initComponents() {
        EnhancedPanel passwdPanel = new EnhancedPanel();
        JLabel passwdLabel = new JLabel();
        JLabel prompt = new JLabel();
        this.resource = new JTextPane();
        passwdPanel.addPanelListener(new PanelListener(){

            @Override
            public void ancestorWindowShown(PanelEvent evt) {
                ReadKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            @Override
            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        passwdPanel.setLayout(new GridBagLayout());
        passwdLabel.setDisplayedMnemonic(resources.getString("passwd").charAt(0));
        passwdLabel.setLabelFor(this.passwdField);
        passwdLabel.setText(resources.getString("passwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        passwdPanel.add((Component)passwdLabel, gridBagConstraints);
        this.passwdField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        passwdPanel.add((Component)this.passwdField, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resource);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)prompt, gridBagConstraints);
        this.resource.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resource.setEditable(false);
        this.resource.setFont(this.resource.getFont().deriveFont(this.resource.getFont().getStyle() | 1));
        this.resource.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resource, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.changeKey.setText(resources.getString("changeKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.changeKey, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ReadKeyPanel.this.passwdField.requestFocusInWindow()) {
                            ReadKeyPanel.this.passwdField.selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

