/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes;

import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.driver.zip.raes.crypto.RaesKeyException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersProvider;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import net.java.truevfs.key.spec.KeyManager;
import net.java.truevfs.key.spec.KeyManagerContainer;
import net.java.truevfs.key.spec.KeyProvider;
import net.java.truevfs.key.spec.UnknownKeyException;
import net.java.truevfs.key.spec.param.AesKeyStrength;
import net.java.truevfs.key.spec.param.AesPbeParameters;

@ThreadSafe
public class KeyManagerRaesParameters
implements RaesParametersProvider {
    protected final KeyManager<AesPbeParameters> manager;
    protected final URI raes;

    public KeyManagerRaesParameters(KeyManagerContainer container, URI raes) {
        this(container.keyManager(AesPbeParameters.class), raes);
    }

    public KeyManagerRaesParameters(@CheckForNull KeyManager<AesPbeParameters> manager, URI raes) {
        this.manager = Objects.requireNonNull(manager);
        this.raes = Objects.requireNonNull(raes);
    }

    @Override
    public <P extends RaesParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(Type0RaesParameters.class)) {
            return (P)((RaesParameters)type.cast(new Type0()));
        }
        return null;
    }

    private class Type0
    implements Type0RaesParameters {
        private Type0() {
        }

        @Override
        public char[] getWritePassword() throws RaesKeyException {
            KeyProvider<AesPbeParameters> provider = KeyManagerRaesParameters.this.manager.make(KeyManagerRaesParameters.this.raes);
            try {
                return provider.getWriteKey().getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public char[] getReadPassword(boolean invalid) throws RaesKeyException {
            KeyProvider<AesPbeParameters> provider = KeyManagerRaesParameters.this.manager.make(KeyManagerRaesParameters.this.raes);
            try {
                return provider.getReadKey(invalid).getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public AesKeyStrength getKeyStrength() throws RaesKeyException {
            KeyProvider<AesPbeParameters> provider = KeyManagerRaesParameters.this.manager.make(KeyManagerRaesParameters.this.raes);
            try {
                return (AesKeyStrength)provider.getWriteKey().getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public void setKeyStrength(AesKeyStrength keyStrength) throws RaesKeyException {
            AesPbeParameters param2;
            KeyProvider<AesPbeParameters> provider = KeyManagerRaesParameters.this.manager.make(KeyManagerRaesParameters.this.raes);
            try {
                param2 = provider.getReadKey(false);
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
            param2.setKeyStrength(keyStrength);
            provider.setKey(param2);
        }
    }
}

