/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import net.java.truevfs.comp.zip.DateTimeConverter;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.kernel.spec.FsArchiveEntries;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import net.java.truevfs.kernel.spec.cio.Entry;

public abstract class AbstractZipDriverEntry
extends ZipEntry
implements FsArchiveEntry {
    protected AbstractZipDriverEntry(String name) {
        super(name);
        assert (this.invariants());
    }

    protected AbstractZipDriverEntry(String name, ZipEntry template) {
        super(name, template);
        assert (this.invariants());
    }

    private boolean invariants() {
        return true;
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    protected abstract DateTimeConverter getDateTimeConverter();

    @Override
    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: {
                return this.getSize();
            }
            case STORAGE: {
                return this.getCompressedSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size type, long size2) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size2);
        return true;
    }

    @Override
    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getTime();
        return 0L <= time ? time : -1L;
    }

    @Override
    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setTime(time);
        return true;
    }

    @Override
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return null;
    }

    @Override
    public boolean setPermitted(Entry.Access type, Entry.Entity entity, Boolean value2) {
        return false;
    }

    @Override
    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

