/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truevfs.comp.zip.crypto.SeekableBlockCipher;
import org.bouncycastle.crypto.Mac;

@NotThreadSafe
public final class CipherReadOnlyChannel
extends ReadOnlyChannel {
    private static final long INVALID = Long.MIN_VALUE;
    private final SeekableBlockCipher cipher;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private byte[] buffer;
    private long blockStart = Long.MIN_VALUE;
    private byte[] block;

    @CreatesObligation
    public CipherReadOnlyChannel(SeekableBlockCipher cipher, @WillCloseWhenClosed SeekableByteChannel channel2) {
        this(cipher, channel2, 8192);
    }

    @CreatesObligation
    public CipherReadOnlyChannel(SeekableBlockCipher cipher, @WillCloseWhenClosed SeekableByteChannel channel2, int bufferSize) {
        super(Objects.requireNonNull(channel2));
        this.cipher = Objects.requireNonNull(cipher);
        int blockSize = cipher.getBlockSize();
        this.block = new byte[blockSize];
        if (bufferSize < blockSize) {
            bufferSize = blockSize;
        }
        this.buffer = new byte[bufferSize / blockSize * blockSize];
        assert (this.buffer.length % blockSize == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] mac(Mac mac) throws IOException {
        long position = this.position();
        try {
            long size2 = this.size();
            int bufferSize = this.buffer.length;
            this.pos = 0L;
            while (this.pos < size2) {
                this.positionBuffer();
                int bufferLimit = (int)Math.min((long)bufferSize, size2 - this.bufferStart);
                assert (0 < bufferLimit);
                mac.update(this.buffer, 0, bufferLimit);
                this.pos += (long)bufferLimit;
            }
            byte[] buf = new byte[mac.getMacSize()];
            int bufLength = mac.doFinal(buf, 0);
            assert (bufLength == buf.length);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            this.position(position);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int blockPos;
        int remaining = dst.remaining();
        if (remaining <= 0) {
            return 0;
        }
        long size2 = this.size();
        if (this.position() >= size2) {
            return -1;
        }
        int total = 0;
        int blockSize = this.block.length;
        this.positionBlock();
        if (this.pos != this.blockStart) {
            assert (this.pos % (long)blockSize != 0L);
            blockPos = (int)(this.pos - this.blockStart);
            int blockLimit = Math.min(remaining, blockSize - blockPos);
            blockLimit = (int)Math.min((long)blockLimit, size2 - this.pos);
            assert (blockLimit > 0);
            dst.put(this.block, blockPos, blockLimit);
            total += blockLimit;
            this.pos += (long)blockLimit;
        }
        if (total < remaining && this.pos < size2 && dst.hasArray()) {
            SeekableBlockCipher cipher = this.cipher;
            byte[] buffer = this.buffer;
            byte[] dstArray = dst.array();
            int dstArrayOffset = dst.arrayOffset();
            int dstPosition = dst.position();
            int dstCapacity = dst.capacity();
            long blockCounter = this.pos / (long)blockSize;
            while (total + blockSize <= remaining && dstPosition + blockSize <= dstCapacity && this.pos + (long)blockSize <= size2) {
                assert (this.pos % (long)blockSize == 0L);
                this.positionBuffer();
                cipher.setBlockCounter(blockCounter++);
                int bufferOff = (int)(this.pos - this.bufferStart);
                int blockLimit = cipher.processBlock(buffer, bufferOff, dstArray, dstArrayOffset + dstPosition);
                assert (blockLimit == blockSize);
                dst.position(dstPosition += blockLimit);
                total += blockLimit;
                this.pos += (long)blockLimit;
            }
        }
        while (total < remaining && this.pos < size2) {
            assert (this.pos % (long)blockSize == 0L);
            this.positionBlock();
            blockPos = (int)(this.pos - this.blockStart);
            int blockLimit = Math.min(remaining - total, blockSize - blockPos);
            blockLimit = (int)Math.min((long)blockLimit, size2 - this.pos);
            assert (blockLimit > 0);
            dst.put(this.block, blockPos, blockLimit);
            total += blockLimit;
            this.pos += (long)blockLimit;
        }
        return total;
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.pos;
    }

    @Override
    public SeekableByteChannel position(long pos) throws IOException {
        if (0L > pos) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        this.pos = pos;
        return this;
    }

    private void positionBlock() throws IOException {
        long nextBlockStart;
        byte[] block = this.block;
        int blockSize = block.length;
        long blockStart = this.blockStart;
        long pos = this.pos;
        if (blockStart <= pos && pos < (nextBlockStart = blockStart + (long)blockSize)) {
            return;
        }
        SeekableBlockCipher cipher = this.cipher;
        assert (null != cipher);
        this.positionBuffer();
        long blockCounter = pos / (long)blockSize;
        cipher.setBlockCounter(blockCounter);
        this.blockStart = blockStart = blockCounter * (long)blockSize;
        int bufferPos = (int)(blockStart - this.bufferStart);
        int processed = cipher.processBlock(this.buffer, bufferPos, block, 0);
        assert (processed == blockSize);
    }

    private void positionBuffer() throws IOException {
        int bufferSize = this.buffer.length;
        long pos = this.pos;
        long bufferStart = this.bufferStart;
        long nextBufferStart = bufferStart + (long)bufferSize;
        if (bufferStart <= pos && pos < nextBufferStart) {
            return;
        }
        try {
            int read2;
            SeekableByteChannel channel2 = this.channel;
            this.bufferStart = bufferStart = pos / (long)bufferSize * (long)bufferSize;
            if (bufferStart != nextBufferStart) {
                channel2.position(bufferStart);
            }
            int total = 0;
            ByteBuffer buffer = ByteBuffer.wrap(this.buffer);
            while ((read2 = channel2.read(buffer)) >= 0 && (total += read2) < bufferSize) {
            }
        }
        catch (Throwable ex) {
            this.bufferStart = Long.MIN_VALUE;
            throw ex;
        }
    }
}

