/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.swing;

import java.awt.Component;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.swing.TFileSystemView;
import net.java.truevfs.access.swing.TFileTree;

final class TFileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1045639746091876245L;
    @CheckForNull
    private transient TFileSystemView fileSystemView;
    private final TFileTree fileTree;

    TFileTreeCellRenderer(TFileTree fileTree) {
        this.fileTree = Objects.requireNonNull(fileTree);
    }

    private TFileSystemView getFileSystemView() {
        TFileSystemView fileSystemView = this.fileSystemView;
        return null != fileSystemView ? fileSystemView : (this.fileSystemView = new TFileSystemView());
    }

    @Override
    @Nullable
    public Icon getOpenIcon() {
        TFile node2;
        Icon icon = super.getOpenIcon();
        return null != icon ? icon : (null != (node2 = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node2) : null);
    }

    @Override
    @Nullable
    public Icon getClosedIcon() {
        TFile node2;
        Icon icon = super.getClosedIcon();
        return null != icon ? icon : (null != (node2 = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node2) : null);
    }

    @Override
    @Nullable
    public Icon getLeafIcon() {
        TFile node2;
        Icon icon = super.getLeafIcon();
        return null != icon ? icon : (null != (node2 = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node2) : null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
        this.setIcon(this.getFileSystemView().getSystemIcon((TFile)value2));
        return this;
    }
}

