/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.HashMaps;
import net.java.truecommons.shed.Paths;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileSystem;
import net.java.truevfs.access.TFileSystemProvider;
import net.java.truevfs.access.TRex;
import net.java.truevfs.access.TUriHelper;
import net.java.truevfs.access.TUriResolver;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class TPath
implements Path,
TRex {
    private static final TPathComparator COMPARATOR = '\\' == File.separatorChar ? new WindowsTPathComparator() : new TPathComparator();
    private final URI name;
    private final TArchiveDetector detector;
    private final FsNodePath nodePath;
    @CheckForNull
    private volatile TFileSystem fileSystem;
    @CheckForNull
    private volatile String string;
    @CheckForNull
    private volatile Integer hashCode;
    @CheckForNull
    private volatile List<String> elements;

    public TPath(String first, String ... more) {
        this(TPath.name(first, more), null, null);
    }

    TPath(TFileSystem fileSystem, String first, String ... more) {
        TArchiveDetector detector;
        URI name;
        this.name = name = TPath.name(TPath.cutLeadingSeparators(first), more);
        this.detector = detector = TConfig.current().getArchiveDetector();
        this.nodePath = new TUriResolver(detector).resolve(new FsNodePath(fileSystem.getMountPoint(), FsNodeName.ROOT), name);
        this.fileSystem = fileSystem;
        assert (this.invariants());
    }

    public TPath(URI name) {
        this(name, null, null);
    }

    public TPath(File file) {
        URI name;
        this.name = name = TPath.name(file.getPath(), new String[0]);
        if (file instanceof TFile) {
            TFile tfile = (TFile)file;
            this.detector = tfile.getArchiveDetector();
            this.nodePath = tfile.getNodePath();
        } else {
            TArchiveDetector detector;
            this.detector = detector = TConfig.current().getArchiveDetector();
            this.nodePath = TPath.nodePath(detector, name);
        }
        assert (this.invariants());
    }

    public TPath(Path path) {
        this(path instanceof TPath ? ((TPath)path).getName() : TPath.name(path.toString().replace(path.getFileSystem().getSeparator(), File.separator), new String[0]), null, null);
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    private TPath(URI name, @CheckForNull TArchiveDetector detector, @CheckForNull FsNodePath nodePath) {
        this.name = name = TPath.name(name);
        if (null == detector) {
            detector = TConfig.current().getArchiveDetector();
        }
        this.detector = detector;
        FsNodePath fsNodePath = this.nodePath = null != nodePath ? nodePath : TPath.nodePath(detector, name);
        assert (this.invariants());
    }

    private static URI name(String first, String ... more) {
        int l = 1 + first.length();
        for (String m : more) {
            l += 1 + m.length();
        }
        StringBuilder b = new StringBuilder(l);
        int i = -1;
        String s = first.replace(File.separatorChar, '/');
        int l2 = s.length();
        for (int k = 0; k < l2; ++k) {
            char c = s.charAt(k);
            if ('/' == c && i > 0 && (0 >= i || '/' == b.charAt(i))) continue;
            b.append(c);
            ++i;
        }
        for (String s2 : more) {
            s2 = s2.replace(File.separatorChar, '/');
            int l3 = s2.length();
            int j = 0;
            for (int k = 0; k < l3; ++k) {
                boolean o;
                char c = s2.charAt(k);
                boolean n = '/' != c;
                boolean bl = o = 0 <= i && '/' != b.charAt(i);
                if (!n && !o) continue;
                if (0 == j && n && o) {
                    b.append('/');
                }
                b.append(c);
                ++i;
                ++j;
            }
        }
        String p = b.toString();
        l2 = TPath.prefixLength(p);
        p = TPath.cutTrailingSeparators(p, l2);
        try {
            if (0 < l2) {
                if ('/' != p.charAt(l2 - 1)) {
                    throw new QuotedUriSyntaxException((Object)p, "Relative path with non-empty prefix.");
                }
                if ('/' == p.charAt(0)) {
                    return new URI(p);
                }
            }
            return new UriBuilder().path(p).getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    private static URI name(URI uri) {
        try {
            uri = TUriHelper.fix(TUriHelper.check(uri));
            int pl = TUriHelper.pathPrefixLength(uri);
            String q = uri.getPath();
            String p = TPath.cutTrailingSeparators(q, pl);
            return p == q ? uri : new UriBuilder(uri).path(p).getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String cutLeadingSeparators(String p) {
        int l = p.length();
        for (int i = 0; i < l; ++i) {
            if ('/' == p.charAt(i)) continue;
            return p.substring(i);
        }
        return "";
    }

    static String cutTrailingSeparators(String p, int o) {
        int i = p.length();
        if (o >= i || '/' != p.charAt(--i)) {
            return p;
        }
        while (o <= i && '/' == p.charAt(--i)) {
        }
        return p.substring(0, ++i);
    }

    private static int prefixLength(String p) {
        return Paths.prefixLength(p, '/', true);
    }

    private static FsNodePath nodePath(TArchiveDetector detector, URI name) {
        TFileSystemProvider provider = TFileSystemProvider.get(name);
        return new TUriResolver(detector).resolve(provider.getRoot(), provider.relativize(name));
    }

    private boolean invariants() {
        assert (null != this.getName());
        assert (null != this.getArchiveDetector());
        assert (null != this.getNodePath());
        return true;
    }

    public boolean isArchive() {
        FsNodePath nodePath = this.getNodePath();
        boolean root2 = nodePath.getNodeName().isRoot();
        FsMountPoint parent = nodePath.getMountPoint().getParent();
        return root2 && null != parent;
    }

    public boolean isEntry() {
        FsNodePath nodePath = this.getNodePath();
        boolean root2 = nodePath.getNodeName().isRoot();
        FsMountPoint parent = nodePath.getMountPoint().getParent();
        return !root2 ? null != parent : null != parent && null != parent.getParent();
    }

    URI getName() {
        return this.name;
    }

    @Override
    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    @Override
    public FsNodePath getNodePath() {
        return this.nodePath;
    }

    @Override
    public FsMountPoint getMountPoint() {
        return this.getNodePath().getMountPoint();
    }

    @Override
    public FsNodeName getNodeName() {
        return this.getNodePath().getNodeName();
    }

    @Override
    public TFileSystem getFileSystem() {
        TFileSystem fs = this.fileSystem;
        return null != fs ? fs : (this.fileSystem = this.getFileSystem0());
    }

    private TFileSystem getFileSystem0() {
        return TFileSystemProvider.get(this.getName()).getFileSystem(this);
    }

    @Override
    public boolean isAbsolute() {
        return TUriHelper.hasAbsolutePath(this.getName());
    }

    public TPath toNonArchivePath() {
        if (!this.isArchive()) {
            return this;
        }
        try (TConfig config = TConfig.open();){
            config.setArchiveDetector(TArchiveDetector.NULL);
            TPath fileName = this.getFileName();
            assert (null != fileName) : "an archive file must not have an empty path name!";
            TPath tPath = this.resolveSibling(fileName);
            return tPath;
        }
    }

    @Override
    @Nullable
    public TPath getRoot() {
        URI n = this.getName();
        String ssp = n.getSchemeSpecificPart();
        int l = TPath.prefixLength(ssp);
        if (l <= 0 || '/' != ssp.charAt(l - 1)) {
            return null;
        }
        return new TPath(TPath.name(ssp.substring(0, l), new String[0]), this.getArchiveDetector(), null);
    }

    @Override
    @Nullable
    public TPath getFileName() {
        List<String> elements = this.getElements();
        int l = elements.size();
        if (l <= 0) {
            return null;
        }
        return new TPath(TPath.name(elements.get(l - 1), new String[0]), this.getArchiveDetector(), null);
    }

    @Override
    @Nullable
    public TPath getParent() {
        int pl;
        URI n = this.getName();
        int l = n.getPath().length();
        if (l <= (pl = TUriHelper.pathPrefixLength(n))) {
            return null;
        }
        URI p = n.resolve(TUriHelper.DOT_URI);
        return p.getPath().isEmpty() ? null : new TPath(p, this.getArchiveDetector(), null);
    }

    private List<String> getElements() {
        List<String> elements = this.elements;
        return null != elements ? elements : (this.elements = this.getElements0());
    }

    private List<String> getElements0() {
        URI n = this.getName();
        String p = n.getPath();
        String[] ss = p.substring(TUriHelper.pathPrefixLength(n)).split("/");
        int i = 0;
        for (String s : ss) {
            if (s.isEmpty()) continue;
            ss[i++] = s;
        }
        return Arrays.asList(ss).subList(0, i);
    }

    @Override
    public int getNameCount() {
        return this.getElements().size();
    }

    @Override
    public TPath getName(int index) {
        return new TPath(this.getElements().get(index), new String[0]);
    }

    @Override
    public TPath subpath(int beginIndex, int endIndex) {
        List<String> segments = this.getElements();
        String first = segments.get(beginIndex);
        String[] more = new String[endIndex - beginIndex - 1];
        return new TPath(first, segments.subList(beginIndex + 1, endIndex).toArray(more));
    }

    @Override
    public boolean startsWith(Path that) {
        if (!this.getFileSystem().equals(that.getFileSystem())) {
            return false;
        }
        return this.startsWith(that.toString());
    }

    @Override
    public boolean startsWith(String other) {
        String name = this.toString();
        int ol = other.length();
        return name.startsWith(other) && (name.length() == ol || File.separatorChar == name.charAt(ol));
    }

    @Override
    public boolean endsWith(Path that) {
        if (!this.getFileSystem().equals(that.getFileSystem())) {
            return false;
        }
        return this.endsWith(that.toString());
    }

    @Override
    public boolean endsWith(String other) {
        int tl;
        String name = this.toString();
        int ol = other.length();
        return name.endsWith(other) && ((tl = name.length()) == ol || File.separatorChar == name.charAt(tl - ol));
    }

    @Override
    public TPath normalize() {
        return new TPath(this.getName().normalize(), this.getArchiveDetector(), this.getNodePath());
    }

    @Override
    public TPath resolve(Path other) {
        if (other instanceof TPath) {
            TPath that = (TPath)other;
            if (that.isAbsolute()) {
                return that;
            }
            if (that.toString().isEmpty()) {
                return this;
            }
            return this.resolve(that.getName());
        }
        return this.resolve(other.toString().replace(other.getFileSystem().getSeparator(), File.separator));
    }

    @Override
    public TPath resolve(String other) {
        return this.resolve(TPath.name(other, new String[0]));
    }

    private TPath resolve(URI other) {
        String namePath;
        URI name;
        name = TUriHelper.hasAbsolutePath(other) || (name = this.getName()).toString().isEmpty() ? other : (other.toString().isEmpty() ? this.getName() : ((namePath = name.getPath()).endsWith("/") ? name.resolve(other) : new UriBuilder(name).path(namePath + '/').toUri().resolve(other)));
        TArchiveDetector detector = TConfig.current().getArchiveDetector();
        FsNodePath path = new TUriResolver(detector).resolve(TUriHelper.hasAbsolutePath(other) ? TFileSystemProvider.get(this.getName()).getRoot() : this.getNodePath(), other);
        return new TPath(name, detector, path);
    }

    @Override
    public TPath resolveSibling(Path other) {
        if (!(other instanceof TPath)) {
            return this.resolveSibling(new TPath(other));
        }
        TPath o = (TPath)other;
        if (o.isAbsolute()) {
            return o;
        }
        TPath p = this.getParent();
        if (null == p) {
            return o;
        }
        if (o.toString().isEmpty()) {
            return p;
        }
        return p.resolve(o);
    }

    @Override
    public TPath resolveSibling(String other) {
        return this.resolveSibling(new TPath(other, new String[0]));
    }

    @Override
    public TPath relativize(Path other) {
        return new TPath(this.getUri().relativize(other.toUri()));
    }

    @Override
    public URI getUri() {
        URI n = this.getName();
        String s = n.getScheme();
        return new UriBuilder(this.getNodePath().getHierarchicalUri()).scheme(null != s ? s : TFileSystemProvider.get(n).getScheme()).toUri();
    }

    @Override
    public URI toUri() {
        return this.getUri();
    }

    @Override
    public TPath toAbsolutePath() {
        return new TPath(this.getUri(), this.getArchiveDetector(), this.getNodePath());
    }

    @Override
    public TPath toRealPath(LinkOption ... options) throws IOException {
        return new TPath(this.getUri(), this.getArchiveDetector(), this.getNodePath());
    }

    @Override
    public TFile toFile() {
        try {
            return this.getName().isAbsolute() ? new TFile(this.getNodePath(), this.getArchiveDetector()) : new TFile(this.toString(), this.getArchiveDetector());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    @Override
    public TPath toPath() {
        return this;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events2, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<Path> iterator() {
        return new SegmentIterator(this);
    }

    @Override
    public int compareTo(Path other) {
        return COMPARATOR.compare(this, (TPath)other);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof TPath && COMPARATOR.equals(this, (TPath)other);
    }

    @Override
    public int hashCode() {
        return COMPARATOR.hashCode(this);
    }

    @Override
    public String toString() {
        String string2 = this.string;
        return null != string2 ? string2 : (this.string = this.toString0());
    }

    private String toString0() {
        URI name = this.getName();
        return name.isAbsolute() ? name.toString() : name.getSchemeSpecificPart().replace('/', File.separatorChar);
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getFileSystem().newByteChannel(this, options, attrs);
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        return this.getFileSystem().newInputStream(this, options);
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        return this.getFileSystem().newOutputStream(this, options);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter2) throws IOException {
        return this.getFileSystem().newDirectoryStream(this, filter2);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.getFileSystem().createDirectory(this, attrs);
    }

    void delete() throws IOException {
        this.getFileSystem().delete(this);
    }

    FsNode stat() throws IOException {
        return this.getFileSystem().stat(this);
    }

    InputSocket<?> input(BitField<FsAccessOption> options) {
        return this.getFileSystem().input(this, options);
    }

    OutputSocket<?> output(BitField<FsAccessOption> options, @CheckForNull Entry template) {
        return this.getFileSystem().output(this, options, template);
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        this.getFileSystem().checkAccess(this, modes);
    }

    @Nullable
    <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) {
        return this.getFileSystem().getFileAttributeView(this, type, options);
    }

    <A extends BasicFileAttributes> A readAttributes(Class<A> type, LinkOption ... options) throws IOException {
        return this.getFileSystem().readAttributes(this, type, options);
    }

    BitField<FsAccessOption> inputOptions(OpenOption ... options) {
        HashSet set = new HashSet(HashMaps.initialCapacity(options.length));
        Collections.addAll(set, options);
        return this.inputOptions(set);
    }

    BitField<FsAccessOption> inputOptions(Set<? extends OpenOption> options) {
        int s = options.size();
        if (0 == s || 1 == s && options.contains(StandardOpenOption.READ)) {
            return this.getAccessPreferences();
        }
        throw new IllegalArgumentException(options.toString());
    }

    BitField<FsAccessOption> outputOptions(OpenOption ... options) {
        HashSet set = new HashSet(HashMaps.initialCapacity(options.length));
        Collections.addAll(set, options);
        return this.outputOptions(set);
    }

    BitField<FsAccessOption> outputOptions(Set<? extends OpenOption> options) {
        EnumSet<FsAccessOption> set = EnumSet.noneOf(FsAccessOption.class);
        block6: for (OpenOption openOption : options) {
            if (!(openOption instanceof StandardOpenOption)) {
                throw new UnsupportedOperationException(openOption.toString());
            }
            switch ((StandardOpenOption)openOption) {
                case READ: {
                    throw new IllegalArgumentException(openOption.toString());
                }
                case WRITE: 
                case TRUNCATE_EXISTING: 
                case CREATE: {
                    continue block6;
                }
                case APPEND: {
                    set.add(FsAccessOption.APPEND);
                    continue block6;
                }
                case CREATE_NEW: {
                    set.add(FsAccessOption.EXCLUSIVE);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(openOption.toString());
        }
        BitField<FsAccessOption> prefs = this.getAccessPreferences();
        return set.isEmpty() ? prefs : prefs.or(BitField.copyOf(set));
    }

    BitField<FsAccessOption> getAccessPreferences() {
        BitField<FsAccessOption> preferences = TConfig.current().getAccessPreferences();
        return null != this.getMountPoint().getParent() ? preferences : preferences.clear(FsAccessOption.CREATE_PARENTS);
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class WindowsTPathComparator
    extends TPathComparator {
        private WindowsTPathComparator() {
        }

        @Override
        public int compare(TPath p1, TPath p2) {
            return p1.toString().compareToIgnoreCase(p2.toString());
        }

        @Override
        boolean equals(TPath p1, TPath p2) {
            return p1.getNodePath().getMountPoint().equals(p2.getNodePath().getMountPoint()) && p1.toString().equalsIgnoreCase(p2.toString());
        }

        @Override
        int hashCode(TPath p) {
            Integer hashCode = p.hashCode;
            if (null != hashCode) {
                return hashCode;
            }
            int result2 = 17;
            result2 = 37 * result2 + p.getNodePath().getMountPoint().hashCode();
            result2 = 37 * result2 + p.toString().toLowerCase(Locale.getDefault()).hashCode();
            return p.hashCode = result2;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class TPathComparator
    implements Comparator<TPath> {
        private TPathComparator() {
        }

        @Override
        public int compare(TPath p1, TPath p2) {
            return p1.toString().compareTo(p2.toString());
        }

        boolean equals(TPath p1, TPath p2) {
            return p1.getNodePath().getMountPoint().equals(p2.getNodePath().getMountPoint()) && p1.toString().equals(p2.toString());
        }

        int hashCode(TPath p) {
            Integer hashCode = p.hashCode;
            if (null != hashCode) {
                return hashCode;
            }
            int result2 = 17;
            result2 = 37 * result2 + p.getNodePath().getMountPoint().hashCode();
            result2 = 37 * result2 + p.toString().hashCode();
            return p.hashCode = result2;
        }
    }

    private static final class SegmentIterator
    implements Iterator<Path> {
        final Iterator<String> i;

        SegmentIterator(TPath path) {
            this.i = path.getElements().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Path next() {
            return new TPath(this.i.next(), new String[0]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

