/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFileSystem;
import net.java.truevfs.access.TPath;
import net.java.truevfs.access.TUriHelper;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoSockets;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TFileSystemProvider
extends FileSystemProvider {
    public static final String DEFAULT_SCHEME = "tpath";
    public static final String DEFAULT_ROOT_MOUNT_POINT = "file:/";
    private static final URI DEFAULT_ROOT_MOUNT_POINT_URI = URI.create("file:/");
    private static final Map<String, TFileSystemProvider> providers = new WeakHashMap<String, TFileSystemProvider>();
    private final String scheme;
    private final FsNodePath root;
    private Map<FsMountPoint, WeakReference<TFileSystem>> fileSystems = new WeakHashMap<FsMountPoint, WeakReference<TFileSystem>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TFileSystemProvider get(URI name) {
        if (!TUriHelper.hasAbsolutePath(name)) {
            return Lazy.CURRENT_DIRECTORY_PROVIDER;
        }
        if (!name.isAbsolute()) {
            name = DEFAULT_ROOT_MOUNT_POINT_URI;
        }
        String scheme = name.getScheme();
        Class<TFileSystemProvider> clazz = TFileSystemProvider.class;
        synchronized (TFileSystemProvider.class) {
            TFileSystemProvider provider = providers.get(scheme);
            if (null == provider) {
                provider = new TFileSystemProvider(scheme, name.resolve("/"));
                providers.put(scheme, provider);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public TFileSystemProvider() {
        this(DEFAULT_SCHEME, DEFAULT_ROOT_MOUNT_POINT_URI);
        Class<TFileSystemProvider> clazz = TFileSystemProvider.class;
        synchronized (TFileSystemProvider.class) {
            providers.put(this.scheme, this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LoggerFactory.getLogger(TFileSystemProvider.class).debug("installed");
            return;
        }
    }

    private TFileSystemProvider(String scheme, URI root2) {
        assert (null != scheme);
        this.scheme = scheme;
        this.root = FsNodePath.create(root2);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    FsNodePath getRoot() {
        return this.root;
    }

    URI relativize(URI name) {
        return name.isAbsolute() ? new UriBuilder(name).scheme(null).toUri() : name;
    }

    private static TConfig open(Map<String, ?> env) {
        TConfig config = TConfig.open();
        TArchiveDetector detector = (TArchiveDetector)env.get("archiveDetector");
        if (null != detector) {
            config.setArchiveDetector(detector);
        }
        return config;
    }

    @Override
    public TFileSystem newFileSystem(Path path, Map<String, ?> configuration) {
        try (TConfig config = TFileSystemProvider.open(configuration);){
            TPath p = new TPath(path);
            if (null == p.getMountPoint().getParent()) {
                throw new UnsupportedOperationException("No prospective archive file detected.");
            }
            TFileSystem tFileSystem = p.getFileSystem();
            return tFileSystem;
        }
    }

    @Override
    public TFileSystem newFileSystem(URI uri, Map<String, ?> configuration) {
        try (TConfig config = TFileSystemProvider.open(configuration);){
            TFileSystem tFileSystem = this.getFileSystem(uri);
            return tFileSystem;
        }
    }

    @Override
    public TFileSystem getFileSystem(URI uri) {
        assert (uri.isAbsolute());
        assert (!uri.isOpaque());
        return this.getPath(uri).getFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFileSystem getFileSystem(TPath path) {
        FsMountPoint mp = path.getMountPoint();
        TFileSystemProvider tFileSystemProvider = this;
        synchronized (tFileSystemProvider) {
            TFileSystem fs = (TFileSystem)TFileSystemProvider.deref(this.fileSystems.get(mp));
            if (null == fs) {
                fs = new TFileSystem(path);
                this.fileSystems.put(mp, new WeakReference<TFileSystem>(fs));
            }
            return fs;
        }
    }

    private static <T> T deref(Reference<T> ref) {
        return null != ref ? (T)ref.get() : null;
    }

    @Override
    public TPath getPath(URI name) {
        if (!this.getScheme().equals(name.getScheme())) {
            throw new IllegalArgumentException();
        }
        return new TPath(name);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return TFileSystemProvider.promote(path).newByteChannel(options, attrs);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).newOutputStream(options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
        return TFileSystemProvider.promote(dir).newDirectoryStream(filter2);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        TFileSystemProvider.promote(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        TFileSystemProvider.promote(path).delete();
    }

    @Override
    public void copy(Path source, Path target2, CopyOption ... options) throws IOException {
        TFileSystemProvider.copy(TFileSystemProvider.promote(source), TFileSystemProvider.promote(target2), options);
    }

    private static void copy(TPath src, TPath dst, CopyOption ... options) throws IOException {
        if (TFileSystemProvider.isSameFile0(src, dst)) {
            throw new FileSystemException(src.toString(), dst.toString(), "Source and destination are the same file!");
        }
        boolean preserve = false;
        BitField<FsAccessOption> o = dst.getAccessPreferences().set(FsAccessOption.EXCLUSIVE);
        block7: for (CopyOption option : options) {
            if (!(option instanceof StandardCopyOption)) {
                throw new UnsupportedOperationException(option.toString());
            }
            switch ((StandardCopyOption)option) {
                case REPLACE_EXISTING: {
                    o = o.clear(FsAccessOption.EXCLUSIVE);
                    continue block7;
                }
                case COPY_ATTRIBUTES: {
                    preserve = true;
                    continue block7;
                }
                case ATOMIC_MOVE: {
                    throw new AtomicMoveNotSupportedException(src.toString(), dst.toString(), null);
                }
                default: {
                    throw new UnsupportedOperationException(option.toString());
                }
            }
        }
        FsNode srcEntry = src.stat();
        FsNode dstEntry = dst.stat();
        if (null == srcEntry) {
            throw new NoSuchFileException(src.toString());
        }
        if (!srcEntry.isType(Entry.Type.FILE)) {
            throw new FileSystemException(src.toString(), null, "Expected type FILE, but is " + srcEntry.getTypes() + "!");
        }
        if (null != dstEntry) {
            if (o.get(FsAccessOption.EXCLUSIVE)) {
                throw new FileAlreadyExistsException(dst.toString());
            }
            if (dstEntry.isType(Entry.Type.DIRECTORY)) {
                try {
                    dst.delete();
                }
                catch (IOException ex) {
                    if (!dstEntry.getMembers().isEmpty()) {
                        throw (IOException)new DirectoryNotEmptyException(dst.toString()).initCause(ex);
                    }
                    throw ex;
                }
            }
        }
        InputSocket<?> input2 = src.input(src.getAccessPreferences());
        OutputSocket<?> output2 = dst.output(o, preserve ? (Entry)input2.target() : null);
        IoSockets.copy(input2, output2);
    }

    @Override
    public void move(Path source, Path target2, CopyOption ... options) throws IOException {
        TFileSystemProvider.move(TFileSystemProvider.promote(source), TFileSystemProvider.promote(target2), options);
    }

    private static void move(TPath source, TPath target2, CopyOption ... options) throws IOException {
        TFileSystemProvider.copy(source, target2, StandardCopyOption.COPY_ATTRIBUTES);
        source.delete();
    }

    @Override
    public boolean isSameFile(Path a, Path b) throws IOException {
        return TFileSystemProvider.isSameFile0(a, b);
    }

    private static boolean isSameFile0(Path a, Path b) throws IOException {
        return a.equals(b) || a.toRealPath(new LinkOption[0]).equals(b.toRealPath(new LinkOption[0]));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return TFileSystemProvider.promote(path).getFileName().toString().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        TFileSystemProvider.promote(path).checkAccess(modes);
    }

    @Override
    @Nullable
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return TFileSystemProvider.promote(path).getFileAttributeView(type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).readAttributes(type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value2, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static TPath promote(Path path) {
        try {
            return (TPath)path;
        }
        catch (ClassCastException ex) {
            throw (ProviderMismatchException)new ProviderMismatchException(ex.toString()).initCause(ex);
        }
    }

    private static final class Lazy {
        static final TFileSystemProvider CURRENT_DIRECTORY_PROVIDER = new TFileSystemProvider("file", new File("").toURI());

        private Lazy() {
        }
    }

    public static interface Parameter {
        public static final String ARCHIVE_DETECTOR = "archiveDetector";
    }
}

