/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.io.DecoratingSeekableChannel;

@ThreadSafe
public class LockSeekableChannel
extends DecoratingSeekableChannel {
    private final Lock lock;

    protected LockSeekableChannel(Lock lock) {
        this.lock = Objects.requireNonNull(lock);
    }

    public LockSeekableChannel(Lock lock, @WillCloseWhenClosed SeekableByteChannel channel2) {
        this(lock);
        this.channel = Objects.requireNonNull(channel2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public boolean isOpen() {
        this.lock.lock();
        try {
            boolean bl = this.channel.isOpen();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read(ByteBuffer dst) throws IOException {
        this.lock.lock();
        try {
            int n = this.channel.read(dst);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int write(ByteBuffer src) throws IOException {
        this.lock.lock();
        try {
            int n = this.channel.write(src);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public long position() throws IOException {
        this.lock.lock();
        try {
            long l = this.channel.position();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public SeekableByteChannel position(long pos) throws IOException {
        this.lock.lock();
        try {
            this.channel.position(pos);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public long size() throws IOException {
        this.lock.lock();
        try {
            long l = this.channel.size();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public SeekableByteChannel truncate(long size2) throws IOException {
        this.lock.lock();
        try {
            this.channel.truncate(size2);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.channel.close();
        }
        finally {
            this.lock.unlock();
        }
    }
}

