/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import scala.actors.threadpool.AbstractQueue;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.helpers.Utils;
import scala.actors.threadpool.locks.ReentrantLock;

public class SynchronousQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean bl) {
        if (bl) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkCancelledConsumer(Node node2) {
        if (this.waitingConsumers.shouldUnlink(node2)) {
            this.qlock.lock();
            try {
                if (this.waitingConsumers.shouldUnlink(node2)) {
                    this.waitingConsumers.unlink(node2);
                }
            }
            finally {
                this.qlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkCancelledProducer(Node node2) {
        if (this.waitingProducers.shouldUnlink(node2)) {
            this.qlock.lock();
            try {
                if (this.waitingProducers.shouldUnlink(node2)) {
                    this.waitingProducers.unlink(node2);
                }
            }
            finally {
                this.qlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        Node node2;
        if (object == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node2 = this.waitingConsumers.deq();
                bl = node2 == null;
                if (bl) {
                    node2 = this.waitingProducers.enq(object);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl) continue;
            try {
                node2.waitForTake();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledProducer(node2);
                throw interruptedException;
            }
        } while (!node2.setItem(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        Node node2;
        if (object == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node2 = this.waitingConsumers.deq();
                bl = node2 == null;
                if (bl) {
                    node2 = this.waitingProducers.enq(object);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl) continue;
            try {
                boolean bl2 = node2.waitForTake(l2);
                if (!bl2) {
                    this.unlinkCancelledProducer(node2);
                }
                return bl2;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledProducer(node2);
                throw interruptedException;
            }
        } while (!node2.setItem(object));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Node node2;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node2 = this.waitingProducers.deq();
                bl = node2 == null;
                if (bl) {
                    node2 = this.waitingConsumers.enq(null);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl) continue;
            try {
                object = node2.waitForPut();
                return object;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledConsumer(node2);
                throw interruptedException;
            }
        } while ((object = node2.getItem()) == null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Node node2;
        Object object;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node2 = this.waitingProducers.deq();
                bl = node2 == null;
                if (bl) {
                    node2 = this.waitingConsumers.enq(null);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl) continue;
            try {
                object = node2.waitForPut(l2);
                if (object == null) {
                    this.unlinkCancelledConsumer(node2);
                }
                return object;
            }
            catch (InterruptedException interruptedException) {
                this.unlinkCancelledConsumer(node2);
                throw interruptedException;
            }
        } while ((object = node2.getItem()) == null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object) {
        Node node2;
        if (object == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            reentrantLock.lock();
            try {
                node2 = this.waitingConsumers.deq();
            }
            finally {
                reentrantLock.unlock();
            }
            if (node2 != null) continue;
            return false;
        } while (!node2.setItem(object));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Node node2;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            reentrantLock.lock();
            try {
                node2 = this.waitingProducers.deq();
            }
            finally {
                reentrantLock.unlock();
            }
            if (node2 != null) continue;
            return null;
        } while ((object = node2.getItem()) == null);
        return object;
    }

    public boolean isEmpty() {
        return true;
    }

    public int size() {
        return 0;
    }

    public int remainingCapacity() {
        return 0;
    }

    public void clear() {
    }

    public boolean contains(Object object) {
        return false;
    }

    public boolean remove(Object object) {
        return false;
    }

    public boolean containsAll(Collection collection) {
        return collection.isEmpty();
    }

    public boolean removeAll(Collection collection) {
        return false;
    }

    public boolean retainAll(Collection collection) {
        return false;
    }

    public Object peek() {
        return null;
    }

    public Iterator iterator() {
        return new EmptyIterator();
    }

    public Object[] toArray() {
        return new Object[0];
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length > 0) {
            objectArray[0] = null;
        }
        return objectArray;
    }

    public int drainTo(Collection collection) {
        Object object;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((object = this.poll()) != null) {
            collection.add(object);
            ++n;
        }
        return n;
    }

    public int drainTo(Collection collection, int n) {
        Object object;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (object = this.poll()) != null; ++n2) {
            collection.add(object);
        }
        return n2;
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    static final class Node
    implements Serializable {
        private static final long serialVersionUID = -3223113410248163686L;
        private static final int ACK = 1;
        private static final int CANCEL = -1;
        int state = 0;
        Object item;
        Node next;

        Node(Object object) {
            this.item = object;
        }

        Node(Object object, Node node2) {
            this.item = object;
            this.next = node2;
        }

        private Object extract() {
            Object object = this.item;
            this.item = null;
            return object;
        }

        private void checkCancellationOnInterrupt(InterruptedException interruptedException) throws InterruptedException {
            if (this.state == 0) {
                this.state = -1;
                this.notify();
                throw interruptedException;
            }
            Thread.currentThread().interrupt();
        }

        synchronized boolean setItem(Object object) {
            if (this.state != 0) {
                return false;
            }
            this.item = object;
            this.state = 1;
            this.notify();
            return true;
        }

        synchronized Object getItem() {
            if (this.state != 0) {
                return null;
            }
            this.state = 1;
            this.notify();
            return this.extract();
        }

        synchronized void waitForTake() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
        }

        synchronized Object waitForPut() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }

        private boolean attempt(long l) throws InterruptedException {
            if (this.state != 0) {
                return true;
            }
            if (l <= 0L) {
                this.state = -1;
                this.notify();
                return false;
            }
            long l2 = Utils.nanoTime() + l;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, l);
                if (this.state == 0) continue;
                return true;
            } while ((l = l2 - Utils.nanoTime()) > 0L);
            this.state = -1;
            this.notify();
            return false;
        }

        synchronized boolean waitForTake(long l) throws InterruptedException {
            try {
                if (!this.attempt(l)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return true;
        }

        synchronized Object waitForPut(long l) throws InterruptedException {
            try {
                if (!this.attempt(l)) {
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3633113410248163686L;
        private transient Node head;

        LifoWaitQueue() {
        }

        Node enq(Object object) {
            this.head = new Node(object, this.head);
            return this.head;
        }

        Node deq() {
            Node node2 = this.head;
            if (node2 != null) {
                this.head = node2.next;
                node2.next = null;
            }
            return node2;
        }

        boolean shouldUnlink(Node node2) {
            return node2 == this.head || node2.next != null;
        }

        void unlink(Node node2) {
            Node node3 = this.head;
            Node node4 = null;
            while (node3 != null) {
                if (node3 == node2) {
                    Node node5 = node3.next;
                    if (node4 == null) {
                        this.head = node5;
                        break;
                    }
                    node4.next = node5;
                    break;
                }
                node4 = node3;
                node3 = node3.next;
            }
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3623113410248163686L;
        private transient Node head;
        private transient Node last;

        FifoWaitQueue() {
        }

        Node enq(Object object) {
            Node node2 = new Node(object);
            this.last = this.last == null ? (this.head = node2) : (this.last.next = node2);
            return node2;
        }

        Node deq() {
            Node node2 = this.head;
            if (node2 != null) {
                this.head = node2.next;
                if (this.head == null) {
                    this.last = null;
                }
                node2.next = null;
            }
            return node2;
        }

        boolean shouldUnlink(Node node2) {
            return node2 == this.last || node2.next != null;
        }

        void unlink(Node node2) {
            Node node3 = this.head;
            Node node4 = null;
            while (node3 != null) {
                if (node3 == node2) {
                    Node node5 = node3.next;
                    if (node4 == null) {
                        this.head = node5;
                    } else {
                        node4.next = node5;
                    }
                    if (this.last != node2) break;
                    this.last = node4;
                    break;
                }
                node4 = node3;
                node3 = node3.next;
            }
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        WaitQueue() {
        }

        abstract Node enq(Object var1);

        abstract Node deq();

        abstract void unlink(Node var1);

        abstract boolean shouldUnlink(Node var1);
    }
}

