/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes;

import java.net.URI;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyManagerMap;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesKeyException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersProvider;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;

@ThreadSafe
public class KeyManagerRaesParameters
implements RaesParametersProvider {
    protected final KeyManager<AesPbeParameters> manager;
    protected final URI raes;

    public KeyManagerRaesParameters(KeyManagerMap container, URI raes) {
        this(container.manager(AesPbeParameters.class), raes);
    }

    public KeyManagerRaesParameters(KeyManager<AesPbeParameters> manager, URI raes) {
        this.manager = Objects.requireNonNull(manager);
        this.raes = Objects.requireNonNull(raes);
    }

    @Override
    public <P extends RaesParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(Type0RaesParameters.class)) {
            return (P)((RaesParameters)type.cast(new Type0()));
        }
        return null;
    }

    private class Type0
    implements Type0RaesParameters {
        private volatile KeyProvider<AesPbeParameters> provider;

        private Type0() {
        }

        private KeyProvider<AesPbeParameters> provider() {
            KeyProvider<AesPbeParameters> p = this.provider;
            return null != p ? p : (this.provider = KeyManagerRaesParameters.this.manager.provider(KeyManagerRaesParameters.this.raes));
        }

        @Override
        public char[] getPasswordForWriting() throws RaesKeyException {
            try {
                return this.provider().getKeyForWriting().getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public char[] getPasswordForReading(boolean invalid) throws RaesKeyException {
            try {
                return this.provider().getKeyForReading(invalid).getPassword();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public AesKeyStrength getKeyStrength() throws RaesKeyException {
            try {
                return (AesKeyStrength)this.provider().getKeyForWriting().getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
        }

        @Override
        public void setKeyStrength(AesKeyStrength keyStrength) throws RaesKeyException {
            AesPbeParameters k;
            KeyProvider<AesPbeParameters> p = this.provider();
            try {
                k = p.getKeyForReading(false);
            }
            catch (UnknownKeyException ex) {
                throw new RaesKeyException(ex);
            }
            k.setKeyStrength(keyStrength);
            p.setKey(k);
        }
    }
}

