/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.PowerBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.util.SuspensionPenalty;
import net.java.truevfs.comp.zip.WinZipAesCipher;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.WinZipAesExtraField;
import net.java.truevfs.comp.zip.ZipAuthenticationException;
import net.java.truevfs.comp.zip.ZipCryptoException;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.crypto.CipherReadOnlyChannel;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class WinZipAesReadOnlyChannel
extends ReadOnlyChannel {
    private final ByteBuffer authenticationCode;
    private final KeyParameter sha1MacParam;
    private final ZipEntry entry;

    @CreatesObligation
    WinZipAesReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel2, WinZipAesEntryParameters param2) throws IOException {
        super(channel2);
        KeyParameter sha1MacParam;
        ParametersWithIV aesCtrParam;
        KeyParameter keyParam;
        ZipEntry entry2 = param2.getEntry();
        assert (entry2.isEncrypted());
        WinZipAesExtraField field2 = (WinZipAesExtraField)entry2.getExtraField(39169);
        if (null == field2) {
            throw new ZipCryptoException(entry2.getName() + " (missing extra field for WinZip AES entry)");
        }
        AesKeyStrength keyStrength = field2.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        ByteBuffer salt = ((PowerBuffer)PowerBuffer.allocate(keyStrengthBytes / 2).load(channel2.position(0L))).buffer();
        ByteBuffer passwdVerifier = ((PowerBuffer)PowerBuffer.allocate(2).load(channel2)).buffer();
        HMac mac = new HMac(new SHA1Digest());
        PowerBuffer<?> footer = PowerBuffer.allocate(mac.getMacSize() / 2);
        long start = channel2.position();
        long end = channel2.size() - (long)footer.limit();
        long size2 = end - start;
        if (0L > size2) {
            throw new ZipCryptoException(entry2.getName() + " (false positive WinZip AES entry is too short)", new EOFException());
        }
        footer.load(channel2.position(end));
        if (channel2.position() != channel2.size()) {
            throw new ZipCryptoException("Expected end of file after WinZip AES authentication code!");
        }
        this.authenticationCode = footer.buffer();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        long lastTry = 0L;
        do {
            byte[] passwd = param2.getReadPassword(0L != lastTry);
            assert (null != passwd);
            gen.init(passwd, salt.array(), 1000);
            assert (128 <= keyStrengthBits);
            keyParam = (KeyParameter)((PBEParametersGenerator)gen).generateDerivedParameters(2 * keyStrengthBits + 16);
            Arrays.fill(passwd, (byte)0);
            byte[] ctrIv = new byte[16];
            aesCtrParam = new ParametersWithIV(new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
            sha1MacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
            lastTry = SuspensionPenalty.enforce(lastTry);
        } while (!passwdVerifier.equals(ByteBuffer.wrap(keyParam.getKey()).position(2 * keyStrengthBytes)));
        this.sha1MacParam = sha1MacParam;
        this.entry = entry2;
        WinZipAesCipher cipher = new WinZipAesCipher();
        cipher.init(false, aesCtrParam);
        this.channel = new CipherReadOnlyChannel(cipher, new IntervalReadOnlyChannel(channel2.position(start), size2));
        param2.setKeyStrength(keyStrength);
    }

    void authenticate() throws IOException {
        HMac mac = new HMac(new SHA1Digest());
        mac.init(this.sha1MacParam);
        byte[] buf = ((CipherReadOnlyChannel)this.channel).mac(mac);
        if (!this.authenticationCode.equals(ByteBuffer.wrap(buf, 0, buf.length / 2))) {
            throw new ZipAuthenticationException(this.entry.getName() + " (authenticated WinZip AES entry content has been tampered with)");
        }
    }
}

