/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.PathSplitter;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TUriHelper;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.FsUriModifier;

@NotThreadSafe
final class TUriResolver {
    private static final String DOT_DOT_SEPARATOR = "../";
    private final TArchiveDetector detector;
    private final PathSplitter splitter = new PathSplitter('/', false);
    private FsNodePath root;
    private String memberQuery;
    private final UriBuilder builder = new UriBuilder();

    TUriResolver(TArchiveDetector detector) {
        assert (null != detector);
        this.detector = detector;
    }

    FsNodePath resolve(FsNodePath base, URI uri) {
        try {
            int max2;
            uri = TUriHelper.fix(TUriHelper.check(uri).normalize());
            if (uri.isAbsolute()) {
                return new FsNodePath(uri, FsUriModifier.CANONICALIZE);
            }
            String path = uri.getPath();
            while (1 < (max2 = Math.min(path.length(), DOT_DOT_SEPARATOR.length())) && DOT_DOT_SEPARATOR.startsWith(path.substring(0, max2))) {
                base = TUriResolver.parent(base);
                path = path.substring(max2);
                uri = new UriBuilder(uri).path(path).getUri();
                if (null != base) continue;
                throw new QuotedUriSyntaxException(uri, "Illegal start of path component");
            }
            int ppl = TUriHelper.pathPrefixLength(uri);
            if (0 < ppl) {
                URI baseUri = base.toHierarchicalUri().resolve(TUriHelper.SEPARATOR_URI);
                String authority = uri.getAuthority();
                String rootPath = null != authority || path.startsWith("/") ? path.substring(0, ppl) : baseUri.getPath() + path.substring(0, ppl);
                this.root = new FsNodePath(new UriBuilder().scheme(baseUri.getScheme()).authority(authority).path(rootPath).getUri());
                path = path.substring(ppl);
            } else {
                this.root = base;
            }
            this.memberQuery = uri.getQuery();
            return this.resolve(path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private FsNodePath resolve(String path) throws URISyntaxException {
        FsNodePath rnp;
        URI npu;
        FsNodePath np;
        FsNodeName nn;
        this.splitter.split(path);
        String pp = this.splitter.getParentPath();
        if (null != pp) {
            nn = new FsNodeName(this.builder.path(this.splitter.getMemberName()).getUri(), FsUriModifier.NULL);
            np = this.resolve(pp);
        } else {
            nn = new FsNodeName(this.builder.path(path).query(this.memberQuery).getUri(), FsUriModifier.CANONICALIZE);
            np = this.root;
        }
        if (nn.isRoot() || (npu = np.getUri()).isOpaque() || !npu.isAbsolute()) {
            rnp = np.resolve(nn);
        } else {
            String npup = npu.getPath();
            if (!npup.endsWith("/")) {
                npu = new UriBuilder(npu).path(npup + '/').getUri();
            }
            rnp = new FsNodePath(new FsMountPoint(npu), nn);
        }
        FsScheme s = this.detector.scheme(nn.toString());
        if (null != s) {
            rnp = new FsNodePath(new FsMountPoint(s, rnp), FsNodeName.ROOT);
        }
        return rnp;
    }

    @Nullable
    static FsNodePath parent(FsNodePath path) throws URISyntaxException {
        FsMountPoint mp = path.getMountPoint();
        FsNodeName en = path.getNodeName();
        if (en.isRoot()) {
            if (null == mp) {
                return null;
            }
            path = mp.getPath();
            if (null != path) {
                return TUriResolver.parent(path);
            }
            URI mpu = mp.getUri();
            URI pu = mpu.resolve(TUriHelper.DOT_DOT_URI);
            if (mpu.getRawPath().length() <= pu.getRawPath().length()) {
                return null;
            }
            return new FsNodePath(pu);
        }
        URI pu = en.getUri().resolve(TUriHelper.DOT_URI);
        en = new FsNodeName(pu, FsUriModifier.CANONICALIZE);
        return new FsNodePath(mp, en);
    }
}

