/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.services;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.logging.BundledMessage;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.services.Container;
import net.java.truecommons.services.Factory;
import net.java.truecommons.services.FactoryWithSomeFunctions;
import net.java.truecommons.services.Function;
import net.java.truecommons.services.Loader;
import net.java.truecommons.services.LocatableComparator;
import net.java.truecommons.services.LocatableDecorator;
import net.java.truecommons.services.LocatableFactory;
import net.java.truecommons.services.LocatableFunction;
import net.java.truecommons.services.LocatableProvider;
import net.java.truecommons.services.ProviderWithSomeFunctions;
import net.java.truecommons.services.Store;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ThreadSafe
public final class Locator {
    private static final Logger logger = new LocalizedLogger(Locator.class);
    private static final Marker CONFIG = MarkerFactory.getMarker("CONFIG");
    private final Loader loader;

    public Locator(Class<?> client) {
        this(client.getClassLoader());
    }

    public Locator(ClassLoader loader) {
        this.loader = new Loader(loader);
    }

    public <P> Factory<P> factory(Class<? extends LocatableFactory<P>> factory) throws ServiceConfigurationError {
        return this.factory(factory, null);
    }

    public <P> Factory<P> factory(Class<? extends LocatableFactory<P>> factory, @CheckForNull Class<? extends LocatableFunction<P>> functions) throws ServiceConfigurationError {
        LocatableFactory<P> p = this.provider(factory);
        LocatableFunction[] f2 = null == functions ? null : this.functions(functions);
        return null == f2 || 0 == f2.length ? p : new FactoryWithSomeFunctions<P>(p, (Function<P>[])f2);
    }

    public <P> Container<P> container(Class<? extends LocatableProvider<P>> provider) throws ServiceConfigurationError {
        return this.container(provider, null);
    }

    public <P> Container<P> container(Class<? extends LocatableProvider<P>> provider, @CheckForNull Class<? extends LocatableDecorator<P>> decorator) throws ServiceConfigurationError {
        LocatableProvider<P> p = this.provider(provider);
        LocatableDecorator[] d = null == decorator ? null : (LocatableDecorator[])this.functions(decorator);
        return new Store<P>(null == d || 0 == d.length ? p : new ProviderWithSomeFunctions<P>(p, d));
    }

    private <S extends LocatableProvider<?>> S provider(Class<S> spec) throws ServiceConfigurationError {
        LocatableProvider service = (LocatableProvider)this.loader.instanceOf(spec, null);
        if (null == service) {
            for (LocatableProvider newService : this.loader.instancesOf(spec)) {
                int np;
                logger.debug(CONFIG, "located", (Object)newService);
                if (null == service) {
                    service = newService;
                    continue;
                }
                int op = service.getPriority();
                if (op < (np = newService.getPriority())) {
                    service = newService;
                    continue;
                }
                if (op != np || service.getClass().getName().equals(newService.getClass().getName())) continue;
                logger.warn("collision", op, service, newService);
            }
        }
        if (null == service) {
            throw new ServiceConfigurationError(new BundledMessage(Locator.class, "null", spec).toString());
        }
        logger.debug(CONFIG, "selecting", (Object)service);
        return (S)service;
    }

    private <S extends LocatableFunction<?>> S[] functions(Class<S> spec) throws ServiceConfigurationError {
        LinkedList<LocatableFunction> c = new LinkedList<LocatableFunction>();
        for (LocatableFunction service : this.loader.instancesOf(spec)) {
            c.add(service);
        }
        LocatableFunction[] a = c.toArray((LocatableFunction[])Array.newInstance(spec, c.size()));
        Arrays.sort(a, new LocatableComparator());
        for (LocatableFunction service : a) {
            logger.debug(CONFIG, "selecting", (Object)service);
        }
        return a;
    }
}

