/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing.io;

import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileSystemView;
import net.java.truecommons.key.swing.util.AbstractComboBoxBrowser;

@NotThreadSafe
public class FileComboBoxBrowser
extends AbstractComboBoxBrowser<String> {
    private static final long serialVersionUID = -6878885832542209810L;
    @CheckForNull
    private transient FileSystemView fileSystemView;
    @CheckForNull
    private transient File directory;

    public FileComboBoxBrowser() {
        this(null, null);
    }

    public FileComboBoxBrowser(@CheckForNull JComboBox<String> comboBox) {
        this(comboBox, null);
    }

    public FileComboBoxBrowser(@CheckForNull FileSystemView fileSystemView) {
        this(null, fileSystemView);
    }

    public FileComboBoxBrowser(@CheckForNull JComboBox<String> comboBox, @CheckForNull FileSystemView fileSystemView) {
        super(comboBox);
        Object item;
        this.fileSystemView = fileSystemView;
        if (null != comboBox && (null == (item = comboBox.getSelectedItem()) || item instanceof String)) {
            this.update0((String)item);
        }
    }

    public File getDirectory() {
        File directory = this.directory;
        return null != directory ? directory : (this.directory = this.getFileSystemView().createFileObject("."));
    }

    public void setDirectory(@CheckForNull File directory) {
        this.directory = directory;
    }

    public FileSystemView getFileSystemView() {
        FileSystemView fileSystemView = this.fileSystemView;
        return null != fileSystemView ? fileSystemView : (this.fileSystemView = FileSystemView.getFileSystemView());
    }

    public void setFileSystemView(@CheckForNull FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView;
    }

    @Override
    protected boolean update(@CheckForNull String initials) {
        return this.update0(initials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update0(@CheckForNull String initials) {
        String prefix;
        String base;
        File dir = this.getDirectory();
        if (null == initials) {
            initials = "";
        }
        if ("".equals(initials)) {
            base = "";
            prefix = "";
        } else {
            File node2 = this.getFileSystemView().createFileObject(initials);
            if (node2.isAbsolute()) {
                boolean dirPath;
                boolean bl = dirPath = node2.getPath().length() < initials.length();
                if (dirPath && node2.isDirectory()) {
                    dir = node2;
                    prefix = "";
                } else {
                    dir = node2.getParentFile();
                    if (dir == null) {
                        dir = node2;
                        prefix = "";
                    } else {
                        prefix = node2.getName();
                    }
                }
                base = dir.getPath().endsWith(File.separator) ? initials.substring(0, dir.getPath().length()) : initials.substring(0, dir.getPath().length() + 1);
            } else {
                boolean dirPath;
                File directory = dir;
                node2 = this.getFileSystemView().createFileObject(directory, initials);
                boolean bl = dirPath = node2.getPath().length() < (directory.getPath() + File.separator + initials).length();
                if (dirPath && node2.isDirectory()) {
                    dir = node2;
                    prefix = "";
                } else {
                    dir = node2.getParentFile();
                    assert (dir != null) : "node is child of directory";
                    prefix = node2.getName();
                }
                base = initials.substring(0, dir.getPath().length() - directory.getPath().length());
            }
        }
        class Filter
        implements FilenameFilter {
            final int pl;

            Filter() {
                this.pl = prefix.length();
            }

            @Override
            public boolean accept(File d, String child) {
                if (child.length() >= this.pl) {
                    return prefix.equalsIgnoreCase(child.substring(0, this.pl));
                }
                return false;
            }
        }
        Filter filter2 = new Filter();
        String[] children2 = dir.list(filter2);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getComboBox().getModel();
        try {
            int l;
            model.removeAllElements();
            int n = l = null == children2 ? 0 : children2.length;
            if (0 < l) {
                Arrays.sort(children2, Collator.getInstance());
                for (int i = 0; i < l; ++i) {
                    model.addElement(base + children2[i]);
                }
                boolean bl = true;
                return bl;
            }
            model.addElement(initials);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!initials.equals(model.getSelectedItem())) {
                model.setSelectedItem(initials);
            }
        }
    }
}

