/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import net.java.truecommons.shed.Filter;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsMountPoint;

public final class FsControllerFilter
implements Filter<FsController> {
    private final String scheme;
    private final String path;
    private final int pathLength;
    private final boolean pathEndsWithSeparator;

    public FsControllerFilter(FsMountPoint prefix) {
        URI p = prefix.toHierarchicalUri();
        this.scheme = p.getScheme();
        this.path = p.getPath();
        this.pathLength = this.path.length();
        this.pathEndsWithSeparator = '/' == this.path.charAt(this.pathLength - 1);
    }

    @Override
    public boolean accept(FsController controller2) {
        String path;
        URI mp = controller2.getModel().getMountPoint().toHierarchicalUri();
        return mp.getScheme().equals(this.scheme) && (path = mp.getPath()).startsWith(this.path) && (this.pathEndsWithSeparator || path.length() == this.pathLength || '/' == path.charAt(this.pathLength));
    }
}

