/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.tardriver;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.comp.tardriver.TarInputService;
import net.java.truevfs.comp.tardriver.TarOutputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.sl.IoBufferPoolLocator;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

@Immutable
public class TarDriver
extends FsArchiveDriver<TarDriverEntry> {
    public static final Charset TAR_CHARSET = Charset.defaultCharset();

    @Override
    public Charset getCharset() {
        return TAR_CHARSET;
    }

    final String getEncoding() {
        return this.getCharset().name();
    }

    public boolean getAddPaxHeaderForNonAsciiNames() {
        return true;
    }

    public int getLongFileMode() {
        return 3;
    }

    public int getBigNumberMode() {
        return 2;
    }

    @Override
    public IoBufferPool getPool() {
        return IoBufferPoolLocator.SINGLETON.get();
    }

    @Override
    public boolean getRedundantContentSupport() {
        return true;
    }

    @Override
    protected InputService<TarDriverEntry> newInput(FsModel model, FsInputSocketSource source) throws IOException {
        return new TarInputService(model, source, this);
    }

    @Override
    protected OutputService<TarDriverEntry> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<TarDriverEntry> input2) throws IOException {
        return new MultiplexingOutputService<TarDriverEntry>(this.getPool(), new TarOutputService(model, sink, this));
    }

    @Override
    protected FsInputSocketSource source(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        options = options.clear(FsAccessOption.CACHE);
        return new FsInputSocketSource(options, controller2.input(options, name));
    }

    @Override
    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        options = options.set(FsAccessOption.COMPRESS);
        return new FsOutputSocketSink(options, controller2.output(options, name, null));
    }

    @Override
    public TarDriverEntry newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        TarDriverEntry entry2;
        name = TarDriver.normalize(name, type);
        if (template instanceof TarArchiveEntry) {
            entry2 = this.newEntry(name, (TarArchiveEntry)((Object)template));
        } else {
            entry2 = this.newEntry(name);
            if (null != template) {
                entry2.setModTime(template.getTime(Entry.Access.WRITE));
                entry2.setSize(template.getSize(Entry.Size.DATA));
                for (Entry.Access access : Entry.ALL_POSIX_ACCESS) {
                    for (Entry.PosixEntity entity : Entry.ALL_POSIX_ENTITIES) {
                        entry2.setPermitted(access, entity, template.isPermitted(access, entity));
                    }
                }
            }
        }
        return entry2;
    }

    public TarDriverEntry newEntry(String name) {
        return new TarDriverEntry(name);
    }

    public TarDriverEntry newEntry(String name, TarArchiveEntry template) {
        return new TarDriverEntry(name, template);
    }
}

