/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import javax.annotation.concurrent.ThreadSafe;
import javax.management.ObjectName;
import net.java.truevfs.comp.inst.InstrumentingModel;
import net.java.truevfs.comp.jmx.JmxComponent;
import net.java.truevfs.comp.jmx.JmxMediator;
import net.java.truevfs.comp.jmx.JmxModelView;
import net.java.truevfs.kernel.spec.FsModel;

@ThreadSafe
public class JmxModel<M extends JmxMediator<M>>
extends InstrumentingModel<M>
implements JmxComponent {
    private final ObjectName objectName = this.objectName();

    public JmxModel(M mediator, FsModel model) {
        super(mediator, model);
    }

    private ObjectName objectName() {
        return ((JmxMediator)this.mediator).nameBuilder(FsModel.class).put("mountPoint", ObjectName.quote(this.model.getMountPoint().toHierarchicalUri().toString())).get();
    }

    protected Object newView() {
        return new JmxModelView<FsModel>(this.model);
    }

    @Override
    public void activate() {
    }

    @Override
    public void setMounted(boolean mounted) {
        if (this.model.isMounted() == mounted) {
            return;
        }
        this.model.setMounted(mounted);
        if (mounted) {
            ((JmxMediator)this.mediator).register(this.objectName, this.newView());
        } else {
            ((JmxMediator)this.mediator).deregister(this.objectName);
        }
    }
}

