/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.CheckForNull;
import net.java.truecommons.key.spec.AbstractKey;
import net.java.truecommons.key.spec.SecretKey;
import net.java.truecommons.shed.Buffers;

public abstract class AbstractSecretKey<K extends AbstractSecretKey<K>>
extends AbstractKey<K>
implements SecretKey<K> {
    @CheckForNull
    private transient ByteBuffer secret;

    @Override
    public K clone() {
        AbstractSecretKey clone2 = (AbstractSecretKey)super.clone();
        clone2.secret = Buffers.copy(this.secret);
        return (K)clone2;
    }

    @Override
    public void reset() {
        this.reset0();
    }

    private void reset0() {
        Buffers.fill(this.secret, (byte)0);
        this.secret = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.reset0();
        }
    }

    @Transient
    public final boolean isSecretSet() {
        return null != this.secret;
    }

    @Override
    @Transient
    @CheckForNull
    public final ByteBuffer getSecret() {
        return Buffers.copy(this.secret);
    }

    @Override
    public final void setSecret(@CheckForNull ByteBuffer secret) {
        this.reset0();
        this.secret = Buffers.copy(secret);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractSecretKey that = (AbstractSecretKey)obj;
        return Objects.equals(this.secret, that.secret);
    }

    @Override
    public int hashCode() {
        int c = 17;
        c = 31 * c + Objects.hashCode(this.secret);
        return c;
    }

    public String toString() {
        return String.format("%s[secretSet=%b]", super.toString(), this.isSecretSet());
    }
}

